/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3presto;

import com.facebook.presto.hive.s3.PrestoS3FileSystem;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.fs.s3.common.AbstractS3FileSystemFactory;
import org.apache.flink.fs.s3.common.writer.S3AccessHelper;
import org.apache.flink.fs.s3presto.common.HadoopConfigLoader;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;

public class S3FileSystemFactory
extends AbstractS3FileSystemFactory {
    private static final String[] FLINK_CONFIG_PREFIXES = new String[]{"s3.", "presto.s3."};
    private static final String[][] MIRRORED_CONFIG_KEYS = new String[][]{{"presto.s3.access.key", "presto.s3.access-key"}, {"presto.s3.secret.key", "presto.s3.secret-key"}, {"presto.s3.path.style.access", "presto.s3.path-style-access"}};

    public S3FileSystemFactory() {
        super("Presto S3 File System", S3FileSystemFactory.createHadoopConfigLoader());
    }

    public String getScheme() {
        return "s3";
    }

    @VisibleForTesting
    static HadoopConfigLoader createHadoopConfigLoader() {
        return new HadoopConfigLoader(FLINK_CONFIG_PREFIXES, MIRRORED_CONFIG_KEYS, "presto.s3.", Collections.emptySet(), Collections.emptySet(), "");
    }

    @Override
    protected FileSystem createHadoopFileSystem() {
        return new PrestoS3FileSystem();
    }

    @Override
    protected URI getInitURI(URI fsUri, Configuration hadoopConfig) {
        String scheme = fsUri.getScheme();
        String authority = fsUri.getAuthority();
        URI initUri = scheme == null && authority == null ? this.createURI("s3://s3.amazonaws.com") : (scheme != null && authority == null ? this.createURI(scheme + "://s3.amazonaws.com") : fsUri);
        return initUri;
    }

    @Override
    @Nullable
    protected S3AccessHelper getS3AccessHelper(FileSystem fs) {
        return null;
    }

    private URI createURI(String str) {
        try {
            return new URI(str);
        }
        catch (URISyntaxException e) {
            throw new FlinkRuntimeException("Error in s3 aws URI - " + str, (Throwable)e);
        }
    }
}

