/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.reader;

import com.facebook.presto.hive.parquet.ParquetValidationUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import parquet.column.statistics.Statistics;
import parquet.format.ColumnChunk;
import parquet.format.ColumnMetaData;
import parquet.format.CompressionCodec;
import parquet.format.ConvertedType;
import parquet.format.Encoding;
import parquet.format.KeyValue;
import parquet.format.RowGroup;
import parquet.format.SchemaElement;
import parquet.format.Type;
import parquet.format.Util;
import parquet.hadoop.metadata.BlockMetaData;
import parquet.hadoop.metadata.ColumnChunkMetaData;
import parquet.hadoop.metadata.ColumnPath;
import parquet.hadoop.metadata.CompressionCodecName;
import parquet.hadoop.metadata.FileMetaData;
import parquet.hadoop.metadata.ParquetMetadata;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.PrimitiveType;
import parquet.schema.Type;
import parquet.schema.Types;

public final class ParquetMetadataReader {
    private static final int PARQUET_METADATA_LENGTH = 4;
    private static final byte[] MAGIC = "PAR1".getBytes(StandardCharsets.US_ASCII);

    private ParquetMetadataReader() {
    }

    public static ParquetMetadata readFooter(FileSystem fileSystem, Path file, long fileSize) throws IOException {
        try (FSDataInputStream inputStream = fileSystem.open(file);){
            ParquetValidationUtils.validateParquet(fileSize >= (long)(MAGIC.length + 4 + MAGIC.length), "%s is not a valid Parquet File", file);
            long metadataLengthIndex = fileSize - 4L - (long)MAGIC.length;
            inputStream.seek(metadataLengthIndex);
            int metadataLength = ParquetMetadataReader.readIntLittleEndian(inputStream);
            byte[] magic = new byte[MAGIC.length];
            inputStream.readFully(magic);
            ParquetValidationUtils.validateParquet(Arrays.equals(MAGIC, magic), "Not valid Parquet file: %s expected magic number: %s got: %s", file, Arrays.toString(MAGIC), Arrays.toString(magic));
            long metadataIndex = metadataLengthIndex - (long)metadataLength;
            ParquetValidationUtils.validateParquet(metadataIndex >= (long)MAGIC.length && metadataIndex < metadataLengthIndex, "Corrupted Parquet file: %s metadata index: %s out of range", file, metadataIndex);
            inputStream.seek(metadataIndex);
            parquet.format.FileMetaData fileMetaData = Util.readFileMetaData((InputStream)inputStream);
            List schema = fileMetaData.getSchema();
            ParquetValidationUtils.validateParquet(!schema.isEmpty(), "Empty Parquet schema in file: %s", file);
            MessageType messageType = ParquetMetadataReader.readParquetSchema(schema);
            ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
            List rowGroups = fileMetaData.getRow_groups();
            if (rowGroups != null) {
                for (RowGroup rowGroup : rowGroups) {
                    BlockMetaData blockMetaData = new BlockMetaData();
                    blockMetaData.setRowCount(rowGroup.getNum_rows());
                    blockMetaData.setTotalByteSize(rowGroup.getTotal_byte_size());
                    List columns = rowGroup.getColumns();
                    ParquetValidationUtils.validateParquet(!columns.isEmpty(), "No columns in row group: %s", rowGroup);
                    String filePath = ((ColumnChunk)columns.get(0)).getFile_path();
                    for (ColumnChunk columnChunk : columns) {
                        ParquetValidationUtils.validateParquet(filePath == null && columnChunk.getFile_path() == null || filePath != null && filePath.equals(columnChunk.getFile_path()), "all column chunks of the same row group must be in the same file", new Object[0]);
                        ColumnMetaData metaData = columnChunk.meta_data;
                        String[] path = metaData.path_in_schema.toArray(new String[metaData.path_in_schema.size()]);
                        ColumnPath columnPath = ColumnPath.get((String[])path);
                        ColumnChunkMetaData column = ColumnChunkMetaData.get((ColumnPath)columnPath, (PrimitiveType.PrimitiveTypeName)messageType.getType(columnPath.toArray()).asPrimitiveType().getPrimitiveTypeName(), (CompressionCodecName)CompressionCodecName.fromParquet((CompressionCodec)metaData.codec), ParquetMetadataReader.readEncodings(metaData.encodings), ParquetMetadataReader.readStats(metaData.statistics, messageType.getType(columnPath.toArray()).asPrimitiveType().getPrimitiveTypeName()), (long)metaData.data_page_offset, (long)metaData.dictionary_page_offset, (long)metaData.num_values, (long)metaData.total_compressed_size, (long)metaData.total_uncompressed_size);
                        blockMetaData.addColumn(column);
                    }
                    blockMetaData.setPath(filePath);
                    blocks.add(blockMetaData);
                }
            }
            HashMap<String, String> keyValueMetaData = new HashMap<String, String>();
            List keyValueList = fileMetaData.getKey_value_metadata();
            if (keyValueList != null) {
                for (KeyValue keyValue : keyValueList) {
                    keyValueMetaData.put(keyValue.key, keyValue.value);
                }
            }
            ParquetMetadata parquetMetadata = new ParquetMetadata(new FileMetaData(messageType, keyValueMetaData, fileMetaData.getCreated_by()), blocks);
            return parquetMetadata;
        }
    }

    private static MessageType readParquetSchema(List<SchemaElement> schema) {
        Iterator<SchemaElement> schemaIterator = schema.iterator();
        SchemaElement rootSchema = schemaIterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        ParquetMetadataReader.readTypeSchema(builder, schemaIterator, rootSchema.getNum_children());
        return builder.named(rootSchema.name);
    }

    private static void readTypeSchema(Types.GroupBuilder<?> builder, Iterator<SchemaElement> schemaIterator, int typeCount) {
        for (int i = 0; i < typeCount; ++i) {
            Types.GroupBuilder typeBuilder;
            SchemaElement element = schemaIterator.next();
            if (element.type == null) {
                typeBuilder = builder.group(Type.Repetition.valueOf((String)element.repetition_type.name()));
                ParquetMetadataReader.readTypeSchema(typeBuilder, schemaIterator, element.num_children);
            } else {
                Types.PrimitiveBuilder primitiveBuilder = builder.primitive(ParquetMetadataReader.getTypeName(element.type), Type.Repetition.valueOf((String)element.repetition_type.name()));
                if (element.isSetType_length()) {
                    primitiveBuilder.length(element.type_length);
                }
                if (element.isSetPrecision()) {
                    primitiveBuilder.precision(element.precision);
                }
                if (element.isSetScale()) {
                    primitiveBuilder.scale(element.scale);
                }
                typeBuilder = primitiveBuilder;
            }
            if (element.isSetConverted_type()) {
                typeBuilder.as(ParquetMetadataReader.getOriginalType(element.converted_type));
            }
            if (element.isSetField_id()) {
                typeBuilder.id(element.field_id);
            }
            typeBuilder.named(element.name);
        }
    }

    public static Statistics<?> readStats(parquet.format.Statistics statistics, PrimitiveType.PrimitiveTypeName type) {
        Statistics stats = Statistics.getStatsBasedOnType((PrimitiveType.PrimitiveTypeName)type);
        if (statistics != null) {
            if (statistics.isSetMax() && statistics.isSetMin()) {
                stats.setMinMaxFromBytes(statistics.min.array(), statistics.max.array());
            }
            stats.setNumNulls(statistics.null_count);
        }
        return stats;
    }

    private static Set<parquet.column.Encoding> readEncodings(List<Encoding> encodings) {
        HashSet<parquet.column.Encoding> columnEncodings = new HashSet<parquet.column.Encoding>();
        for (Encoding encoding : encodings) {
            columnEncodings.add(parquet.column.Encoding.valueOf((String)encoding.name()));
        }
        return Collections.unmodifiableSet(columnEncodings);
    }

    private static PrimitiveType.PrimitiveTypeName getTypeName(Type type) {
        switch (type) {
            case BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.BINARY;
            }
            case INT64: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case INT32: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case BOOLEAN: {
                return PrimitiveType.PrimitiveTypeName.BOOLEAN;
            }
            case FLOAT: {
                return PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.PrimitiveTypeName.DOUBLE;
            }
            case INT96: {
                return PrimitiveType.PrimitiveTypeName.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }

    private static OriginalType getOriginalType(ConvertedType type) {
        switch (type) {
            case UTF8: {
                return OriginalType.UTF8;
            }
            case MAP: {
                return OriginalType.MAP;
            }
            case MAP_KEY_VALUE: {
                return OriginalType.MAP_KEY_VALUE;
            }
            case LIST: {
                return OriginalType.LIST;
            }
            case ENUM: {
                return OriginalType.ENUM;
            }
            case DECIMAL: {
                return OriginalType.DECIMAL;
            }
            case DATE: {
                return OriginalType.DATE;
            }
            case TIME_MILLIS: {
                return OriginalType.TIME_MILLIS;
            }
            case TIMESTAMP_MILLIS: {
                return OriginalType.TIMESTAMP_MILLIS;
            }
            case INTERVAL: {
                return OriginalType.INTERVAL;
            }
            case INT_8: {
                return OriginalType.INT_8;
            }
            case INT_16: {
                return OriginalType.INT_16;
            }
            case INT_32: {
                return OriginalType.INT_32;
            }
            case INT_64: {
                return OriginalType.INT_64;
            }
            case UINT_8: {
                return OriginalType.UINT_8;
            }
            case UINT_16: {
                return OriginalType.UINT_16;
            }
            case UINT_32: {
                return OriginalType.UINT_32;
            }
            case UINT_64: {
                return OriginalType.UINT_64;
            }
            case JSON: {
                return OriginalType.JSON;
            }
            case BSON: {
                return OriginalType.BSON;
            }
        }
        throw new IllegalArgumentException("Unknown converted type " + type);
    }

    private static int readIntLittleEndian(InputStream in) throws IOException {
        int ch4;
        int ch3;
        int ch2;
        int ch1 = in.read();
        if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
            throw new EOFException();
        }
        return (ch4 << 24) + (ch3 << 16) + (ch2 << 8) + ch1;
    }
}

