/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Internal
public final class BackPressuringExecutor
implements Executor {
    private final Executor delegate;
    private final Semaphore permits;

    public BackPressuringExecutor(Executor delegate, int numConcurrentExecutions) {
        Preconditions.checkArgument((numConcurrentExecutions > 0 ? 1 : 0) != 0, (Object)"numConcurrentExecutions must be > 0");
        this.delegate = (Executor)Preconditions.checkNotNull((Object)delegate, (String)"delegate");
        this.permits = new Semaphore(numConcurrentExecutions, true);
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.permits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new FlinkRuntimeException("interrupted:", (Throwable)e);
        }
        SemaphoreReleasingRunnable runnable = new SemaphoreReleasingRunnable(command, this.permits);
        try {
            this.delegate.execute(runnable);
        }
        catch (Throwable e) {
            runnable.release();
            ExceptionUtils.rethrow((Throwable)e, (String)e.getMessage());
        }
    }

    private static class SemaphoreReleasingRunnable
    implements Runnable {
        private final Runnable delegate;
        private final Semaphore toRelease;
        private final AtomicBoolean released = new AtomicBoolean();

        SemaphoreReleasingRunnable(Runnable delegate, Semaphore toRelease) {
            this.delegate = delegate;
            this.toRelease = toRelease;
        }

        @Override
        public void run() {
            try {
                this.delegate.run();
            }
            finally {
                this.release();
            }
        }

        void release() {
            if (this.released.compareAndSet(false, true)) {
                this.toRelease.release();
            }
        }
    }
}

