/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class AsyncQueue<T> {
    private final int targetQueueSize;
    @GuardedBy(value="this")
    private final Queue<T> elements;
    @GuardedBy(value="this")
    private CompletableFuture<?> notFullSignal = new CompletableFuture();
    @GuardedBy(value="this")
    private CompletableFuture<?> notEmptySignal = new CompletableFuture();
    @GuardedBy(value="this")
    private boolean finishing = false;
    private Executor executor;

    public AsyncQueue(int targetQueueSize, Executor executor) {
        Preconditions.checkArgument(targetQueueSize >= 1, "targetQueueSize must be at least 1");
        this.targetQueueSize = targetQueueSize;
        this.elements = new ArrayDeque<T>(targetQueueSize * 2);
        this.executor = Objects.requireNonNull(executor);
    }

    public synchronized int size() {
        return this.elements.size();
    }

    public synchronized boolean isFinished() {
        return this.finishing && this.elements.size() == 0;
    }

    public synchronized void finish() {
        if (this.finishing) {
            return;
        }
        this.finishing = true;
        if (this.elements.size() == 0) {
            AsyncQueue.completeAsync(this.executor, this.notEmptySignal);
            this.notEmptySignal = new CompletableFuture();
        } else if (this.elements.size() >= this.targetQueueSize) {
            AsyncQueue.completeAsync(this.executor, this.notFullSignal);
            this.notFullSignal = new CompletableFuture();
        }
    }

    public synchronized CompletableFuture<?> offer(T element) {
        Objects.requireNonNull(element);
        if (this.finishing) {
            return CompletableFuture.completedFuture(null);
        }
        this.elements.add(element);
        int newSize = this.elements.size();
        if (newSize == 1) {
            AsyncQueue.completeAsync(this.executor, this.notEmptySignal);
            this.notEmptySignal = new CompletableFuture();
        }
        if (newSize >= this.targetQueueSize) {
            return this.notFullSignal;
        }
        return CompletableFuture.completedFuture(null);
    }

    private synchronized List<T> getBatch(int maxSize) {
        int oldSize = this.elements.size();
        int reduceBy = Math.min(maxSize, oldSize);
        if (reduceBy == 0) {
            return ImmutableList.of();
        }
        ArrayList<T> result = new ArrayList<T>(reduceBy);
        for (int i = 0; i < reduceBy; ++i) {
            result.add(this.elements.remove());
        }
        if (oldSize >= this.targetQueueSize && oldSize - reduceBy < this.targetQueueSize) {
            AsyncQueue.completeAsync(this.executor, this.notFullSignal);
            this.notFullSignal = new CompletableFuture();
        }
        return result;
    }

    public synchronized CompletableFuture<List<T>> getBatchAsync(int maxSize) {
        Preconditions.checkArgument(maxSize >= 0, "maxSize must be at least 0");
        List<T> list = this.getBatch(maxSize);
        if (!list.isEmpty()) {
            return CompletableFuture.completedFuture(list);
        }
        if (this.finishing) {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }
        return this.notEmptySignal.thenApplyAsync(x -> this.getBatch(maxSize), this.executor);
    }

    private static void completeAsync(Executor executor, CompletableFuture<?> future) {
        executor.execute(() -> future.complete(null));
    }
}

