/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rcfile;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.rcfile.RcFileCorruptionException;
import com.facebook.presto.rcfile.RcFileReader;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class RcFilePageSource
implements ConnectorPageSource {
    private static final long GUESSED_MEMORY_USAGE = new DataSize(16.0, DataSize.Unit.MEGABYTE).toBytes();
    private static final int NULL_ENTRY_SIZE = 0;
    private final RcFileReader rcFileReader;
    private final List<String> columnNames;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int pageId;
    private boolean closed;

    public RcFilePageSource(RcFileReader rcFileReader, List<HiveColumnHandle> columns, DateTimeZone hiveStorageTimeZone, TypeManager typeManager) {
        Objects.requireNonNull(rcFileReader, "rcReader is null");
        Objects.requireNonNull(columns, "columns is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.rcFileReader = rcFileReader;
        int size = columns.size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        ImmutableList.Builder hiveTypesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            String name = column.getName();
            Type type = typeManager.getType(column.getTypeSignature());
            namesBuilder.add(name);
            typesBuilder.add(type);
            hiveTypesBuilder.add(column.getHiveType());
            this.hiveColumnIndexes[columnIndex] = column.getHiveColumnIndex();
            if (this.hiveColumnIndexes[columnIndex] < rcFileReader.getColumnCount()) continue;
            BlockBuilder blockBuilder = type.createBlockBuilder(new BlockBuilderStatus(), 1, 0);
            blockBuilder.appendNull();
            this.constantBlocks[columnIndex] = blockBuilder.build();
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
    }

    public long getCompletedBytes() {
        return this.rcFileReader.getBytesRead();
    }

    public long getReadTimeNanos() {
        return this.rcFileReader.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public Page getNextPage() {
        try {
            ++this.pageId;
            int currentPageSize = this.rcFileReader.advance();
            if (currentPageSize < 0) {
                this.close();
                return null;
            }
            Block[] blocks = new Block[this.hiveColumnIndexes.length];
            for (int fieldId = 0; fieldId < blocks.length; ++fieldId) {
                blocks[fieldId] = this.constantBlocks[fieldId] != null ? new RunLengthEncodedBlock(this.constantBlocks[fieldId], currentPageSize) : this.createBlock(currentPageSize, fieldId);
            }
            Page page = new Page(currentPageSize, blocks);
            return page;
        }
        catch (PrestoException e) {
            this.closeWithSuppression(e);
            throw e;
        }
        catch (IOException | RuntimeException e) {
            this.closeWithSuppression(e);
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rcFileReader.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("columnNames", this.columnNames).add("types", this.types).toString();
    }

    public long getSystemMemoryUsage() {
        return GUESSED_MEMORY_USAGE;
    }

    private void closeWithSuppression(Throwable throwable) {
        block2: {
            Objects.requireNonNull(throwable, "throwable is null");
            try {
                this.close();
            }
            catch (Exception e) {
                if (e == throwable) break block2;
                throwable.addSuppressed(e);
            }
        }
    }

    private Block createBlock(int currentPageSize, int fieldId) {
        int hiveColumnIndex = this.hiveColumnIndexes[fieldId];
        return new LazyBlock(currentPageSize, (LazyBlockLoader)new RcFileBlockLoader(hiveColumnIndex));
    }

    private final class RcFileBlockLoader
    implements LazyBlockLoader<LazyBlock> {
        private final int expectedBatchId;
        private final int columnIndex;
        private boolean loaded;

        public RcFileBlockLoader(int columnIndex) {
            this.expectedBatchId = RcFilePageSource.this.pageId;
            this.columnIndex = columnIndex;
        }

        public final void load(LazyBlock lazyBlock) {
            if (this.loaded) {
                return;
            }
            Preconditions.checkState(RcFilePageSource.this.pageId == this.expectedBatchId);
            try {
                Block block = RcFilePageSource.this.rcFileReader.readBlock(this.columnIndex);
                lazyBlock.setBlock(block);
            }
            catch (IOException e) {
                if (e instanceof RcFileCorruptionException) {
                    throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
                }
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, (Throwable)e);
            }
            this.loaded = true;
        }
    }
}

