/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.parquet.ParquetEncoding;
import com.facebook.presto.hive.parquet.ParquetPage;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Objects;

public class ParquetDictionaryPage
extends ParquetPage {
    private final Slice slice;
    private final int dictionarySize;
    private final ParquetEncoding encoding;

    public ParquetDictionaryPage(Slice slice, int dictionarySize, ParquetEncoding encoding) {
        this(Objects.requireNonNull(slice, "slice is null"), slice.length(), dictionarySize, Objects.requireNonNull(encoding, "encoding is null"));
    }

    public ParquetDictionaryPage(Slice slice, int uncompressedSize, int dictionarySize, ParquetEncoding encoding) {
        super(Objects.requireNonNull(slice, "slice is null").length(), uncompressedSize);
        this.slice = slice;
        this.dictionarySize = dictionarySize;
        this.encoding = Objects.requireNonNull(encoding, "encoding is null");
    }

    public Slice getSlice() {
        return this.slice;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public ParquetEncoding getEncoding() {
        return this.encoding;
    }

    public ParquetDictionaryPage copy() {
        return new ParquetDictionaryPage(Slices.wrappedBuffer(Arrays.copyOf(this.slice.getBytes(), this.slice.length())), this.getUncompressedSize(), this.dictionarySize, this.encoding);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("slice", this.slice).add("dictionarySize", this.dictionarySize).add("encoding", (Object)this.encoding).add("compressedSize", this.compressedSize).add("uncompressedSize", this.uncompressedSize).toString();
    }
}

