/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartitionKey;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Properties;

public class HiveSplit
implements ConnectorSplit {
    private final String clientId;
    private final String path;
    private final long start;
    private final long length;
    private final long fileSize;
    private final Properties schema;
    private final List<HivePartitionKey> partitionKeys;
    private final List<HostAddress> addresses;
    private final String database;
    private final String table;
    private final String partitionName;
    private final TupleDomain<HiveColumnHandle> effectivePredicate;
    private final OptionalInt bucketNumber;
    private final boolean forceLocalScheduling;
    private final Map<Integer, HiveType> columnCoercions;

    @JsonCreator
    public HiveSplit(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="database") String database, @JsonProperty(value="table") String table, @JsonProperty(value="partitionName") String partitionName, @JsonProperty(value="path") String path, @JsonProperty(value="start") long start, @JsonProperty(value="length") long length, @JsonProperty(value="fileSize") long fileSize, @JsonProperty(value="schema") Properties schema, @JsonProperty(value="partitionKeys") List<HivePartitionKey> partitionKeys, @JsonProperty(value="addresses") List<HostAddress> addresses, @JsonProperty(value="bucketNumber") OptionalInt bucketNumber, @JsonProperty(value="forceLocalScheduling") boolean forceLocalScheduling, @JsonProperty(value="effectivePredicate") TupleDomain<HiveColumnHandle> effectivePredicate, @JsonProperty(value="columnCoercions") Map<Integer, HiveType> columnCoercions) {
        Objects.requireNonNull(clientId, "clientId is null");
        Preconditions.checkArgument(start >= 0L, "start must be positive");
        Preconditions.checkArgument(length >= 0L, "length must be positive");
        Preconditions.checkArgument(fileSize >= 0L, "fileSize must be positive");
        Objects.requireNonNull(database, "database is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(partitionName, "partitionName is null");
        Objects.requireNonNull(path, "path is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(partitionKeys, "partitionKeys is null");
        Objects.requireNonNull(addresses, "addresses is null");
        Objects.requireNonNull(bucketNumber, "bucketNumber is null");
        Objects.requireNonNull(effectivePredicate, "tupleDomain is null");
        Objects.requireNonNull(columnCoercions, "columnCoercions is null");
        this.clientId = clientId;
        this.database = database;
        this.table = table;
        this.partitionName = partitionName;
        this.path = path;
        this.start = start;
        this.length = length;
        this.fileSize = fileSize;
        this.schema = schema;
        this.partitionKeys = ImmutableList.copyOf(partitionKeys);
        this.addresses = ImmutableList.copyOf(addresses);
        this.bucketNumber = bucketNumber;
        this.forceLocalScheduling = forceLocalScheduling;
        this.effectivePredicate = effectivePredicate;
        this.columnCoercions = columnCoercions;
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public String getDatabase() {
        return this.database;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getPartitionName() {
        return this.partitionName;
    }

    @JsonProperty
    public String getPath() {
        return this.path;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getLength() {
        return this.length;
    }

    @JsonProperty
    public long getFileSize() {
        return this.fileSize;
    }

    @JsonProperty
    public Properties getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<HivePartitionKey> getPartitionKeys() {
        return this.partitionKeys;
    }

    @JsonProperty
    public List<HostAddress> getAddresses() {
        return this.addresses;
    }

    @JsonProperty
    public OptionalInt getBucketNumber() {
        return this.bucketNumber;
    }

    @JsonProperty
    public TupleDomain<HiveColumnHandle> getEffectivePredicate() {
        return this.effectivePredicate;
    }

    @JsonProperty
    public boolean isForceLocalScheduling() {
        return this.forceLocalScheduling;
    }

    @JsonProperty
    public Map<Integer, HiveType> getColumnCoercions() {
        return this.columnCoercions;
    }

    public boolean isRemotelyAccessible() {
        return !this.forceLocalScheduling;
    }

    public Object getInfo() {
        return ImmutableMap.builder().put("path", this.path).put("start", (String)((Object)Long.valueOf(this.start))).put("length", (String)((Object)Long.valueOf(this.length))).put("fileSize", (String)((Object)Long.valueOf(this.fileSize))).put("hosts", (String)((Object)this.addresses)).put("database", (List<HostAddress>)((Object)this.database)).put("table", (List<HostAddress>)((Object)this.table)).put("forceLocalScheduling", (List<HostAddress>)this.forceLocalScheduling).put("partitionName", (List<HostAddress>)((Object)this.partitionName)).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.path).addValue(this.start).addValue(this.length).addValue(this.fileSize).addValue(this.effectivePredicate).toString();
    }
}

