/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.memory;

import com.facebook.presto.hive.parquet.memory.AbstractAggregatedMemoryContext;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class AggregatedMemoryContext
extends AbstractAggregatedMemoryContext {
    private final AbstractAggregatedMemoryContext parentMemoryContext;
    private long usedBytes;
    private boolean closed;

    public AggregatedMemoryContext() {
        this.parentMemoryContext = null;
    }

    public AggregatedMemoryContext(AbstractAggregatedMemoryContext parentMemoryContext) {
        this.parentMemoryContext = Objects.requireNonNull(parentMemoryContext, "parentMemoryContext is null");
    }

    public long getBytes() {
        Preconditions.checkState(!this.closed);
        return this.usedBytes;
    }

    @Override
    protected void updateBytes(long bytes) {
        Preconditions.checkState(!this.closed);
        if (this.parentMemoryContext != null) {
            this.parentMemoryContext.updateBytes(bytes);
        }
        this.usedBytes += bytes;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.parentMemoryContext != null) {
            this.parentMemoryContext.updateBytes(-this.usedBytes);
        }
        this.usedBytes = 0L;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("usedBytes", this.usedBytes).add("closed", this.closed).toString();
    }
}

