/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.LruHashMap;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalMetadataStore
implements MetadataStore {
    public static final Logger LOG = LoggerFactory.getLogger(MetadataStore.class);
    public static final int DEFAULT_MAX_RECORDS = 128;
    public static final String CONF_MAX_RECORDS = "fs.metadatastore.local.max_records";
    private LruHashMap<Path, PathMetadata> fileHash;
    private LruHashMap<Path, DirListingMetadata> dirHash;
    private FileSystem fs;
    private String uriHost;

    @Override
    public void initialize(FileSystem fileSystem) throws IOException {
        Preconditions.checkNotNull(fileSystem);
        this.fs = fileSystem;
        URI fsURI = this.fs.getUri();
        this.uriHost = fsURI.getHost();
        if (this.uriHost != null && this.uriHost.equals("")) {
            this.uriHost = null;
        }
        this.initialize(this.fs.getConf());
    }

    @Override
    public void initialize(Configuration conf) throws IOException {
        Preconditions.checkNotNull(conf);
        int maxRecords = conf.getInt(CONF_MAX_RECORDS, 128);
        if (maxRecords < 4) {
            maxRecords = 4;
        }
        this.fileHash = new LruHashMap(maxRecords / 2, maxRecords);
        this.dirHash = new LruHashMap(maxRecords / 4, maxRecords);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LocalMetadataStore{");
        sb.append("uriHost='").append(this.uriHost).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void delete(Path p) throws IOException {
        this.doDelete(p, false, true);
    }

    @Override
    public void forgetMetadata(Path p) throws IOException {
        this.doDelete(p, false, false);
    }

    @Override
    public void deleteSubtree(Path path) throws IOException {
        this.doDelete(path, true, true);
    }

    private synchronized void doDelete(Path p, boolean recursive, boolean tombstone) {
        Path path = this.standardize(p);
        this.deleteHashEntries(path, tombstone);
        if (recursive) {
            LocalMetadataStore.deleteHashByAncestor(path, this.dirHash, tombstone);
            LocalMetadataStore.deleteHashByAncestor(path, this.fileHash, tombstone);
        }
    }

    @Override
    public synchronized PathMetadata get(Path p) throws IOException {
        return this.get(p, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PathMetadata get(Path p, boolean wantEmptyDirectoryFlag) throws IOException {
        Path path = this.standardize(p);
        LocalMetadataStore localMetadataStore = this;
        synchronized (localMetadataStore) {
            PathMetadata m = this.fileHash.mruGet(path);
            if (wantEmptyDirectoryFlag && m != null && m.getFileStatus().isDirectory()) {
                m.setIsEmptyDirectory(this.isEmptyDirectory(p));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("get({}) -> {}", (Object)path, (Object)(m == null ? "null" : m.prettyPrint()));
            }
            return m;
        }
    }

    private Tristate isEmptyDirectory(Path p) {
        DirListingMetadata dirMeta = (DirListingMetadata)this.dirHash.get(p);
        return dirMeta.withoutTombstones().isEmpty();
    }

    @Override
    public synchronized DirListingMetadata listChildren(Path p) throws IOException {
        Path path = this.standardize(p);
        DirListingMetadata listing = this.dirHash.mruGet(path);
        if (LOG.isDebugEnabled()) {
            LOG.debug("listChildren({}) -> {}", (Object)path, (Object)(listing == null ? "null" : listing.prettyPrint()));
        }
        return listing == null ? null : new DirListingMetadata(listing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void move(Collection<Path> pathsToDelete, Collection<PathMetadata> pathsToCreate) throws IOException {
        Preconditions.checkNotNull(pathsToDelete, "pathsToDelete is null");
        Preconditions.checkNotNull(pathsToCreate, "pathsToCreate is null");
        Preconditions.checkArgument(pathsToDelete.size() == pathsToCreate.size(), "Must supply same number of paths to delete/create.");
        LocalMetadataStore localMetadataStore = this;
        synchronized (localMetadataStore) {
            for (Path path : pathsToDelete) {
                LOG.debug("move: deleting metadata {}", (Object)path);
                this.delete(path);
            }
            for (PathMetadata pathMetadata : pathsToCreate) {
                LOG.debug("move: adding metadata {}", (Object)pathMetadata);
                this.put(pathMetadata);
            }
            for (PathMetadata pathMetadata : pathsToCreate) {
                DirListingMetadata dir;
                FileStatus status = pathMetadata.getFileStatus();
                if (status == null || status.isDirectory() || (dir = this.listChildren(status.getPath())) == null) continue;
                dir.setAuthoritative(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(PathMetadata meta) throws IOException {
        Preconditions.checkNotNull(meta);
        FileStatus status = meta.getFileStatus();
        Path path = this.standardize(status.getPath());
        LocalMetadataStore localMetadataStore = this;
        synchronized (localMetadataStore) {
            Path parentPath;
            DirListingMetadata dir;
            if (LOG.isDebugEnabled()) {
                LOG.debug("put {} -> {}", (Object)path, (Object)meta.prettyPrint());
            }
            this.fileHash.put(path, meta);
            if (status.isDirectory() && (dir = this.dirHash.mruGet(path)) == null) {
                this.dirHash.put(path, new DirListingMetadata(path, DirListingMetadata.EMPTY_DIR, false));
            }
            if ((parentPath = path.getParent()) != null) {
                DirListingMetadata parent = this.dirHash.mruGet(parentPath);
                if (parent == null) {
                    parent = new DirListingMetadata(parentPath, DirListingMetadata.EMPTY_DIR, false);
                    this.dirHash.put(parentPath, parent);
                }
                parent.put(status);
            }
        }
    }

    @Override
    public synchronized void put(DirListingMetadata meta) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("put dirMeta {}", (Object)meta.prettyPrint());
        }
        this.dirHash.put(this.standardize(meta.getPath()), meta);
    }

    @Override
    public synchronized void put(Collection<PathMetadata> metas) throws IOException {
        for (PathMetadata meta : metas) {
            this.put(meta);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void destroy() throws IOException {
        if (this.dirHash != null) {
            this.dirHash.clear();
        }
    }

    @Override
    public synchronized void prune(long modTime) throws IOException {
        Iterator files = this.fileHash.entrySet().iterator();
        while (files.hasNext()) {
            Map.Entry entry = files.next();
            if (!this.expired(((PathMetadata)entry.getValue()).getFileStatus(), modTime)) continue;
            files.remove();
        }
        for (Map.Entry entry : this.dirHash.entrySet()) {
            DirListingMetadata parent;
            Path path = (Path)entry.getKey();
            DirListingMetadata metadata = (DirListingMetadata)entry.getValue();
            Collection<PathMetadata> oldChildren = metadata.getListing();
            LinkedList<PathMetadata> newChildren = new LinkedList<PathMetadata>();
            for (PathMetadata child : oldChildren) {
                FileStatus status = child.getFileStatus();
                if (this.expired(status, modTime)) continue;
                newChildren.add(child);
            }
            if (newChildren.size() == oldChildren.size()) continue;
            this.dirHash.put(path, new DirListingMetadata(path, newChildren, false));
            if (path.isRoot() || (parent = (DirListingMetadata)this.dirHash.get(path.getParent())) == null) continue;
            parent.setAuthoritative(false);
        }
    }

    private boolean expired(FileStatus status, long expiry) {
        return status.getModificationTime() < expiry && !status.isDirectory();
    }

    @VisibleForTesting
    static <T> void deleteHashByAncestor(Path ancestor, Map<Path, T> hash, boolean tombstone) {
        Iterator<Map.Entry<Path, T>> it = hash.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Path, T> entry = it.next();
            Path f = entry.getKey();
            T meta = entry.getValue();
            if (!LocalMetadataStore.isAncestorOf(ancestor, f)) continue;
            if (tombstone) {
                if (meta instanceof PathMetadata) {
                    entry.setValue(PathMetadata.tombstone(f));
                    continue;
                }
                if (meta instanceof DirListingMetadata) {
                    it.remove();
                    continue;
                }
                throw new IllegalStateException("Unknown type in hash");
            }
            it.remove();
        }
    }

    private static boolean isAncestorOf(Path ancestor, Path f) {
        String aStr = ancestor.toString();
        if (!ancestor.isRoot()) {
            aStr = aStr + "/";
        }
        String fStr = f.toString();
        return fStr.startsWith(aStr);
    }

    private void deleteHashEntries(Path path, boolean tombstone) {
        DirListingMetadata dir;
        LOG.debug("delete file entry for {}", (Object)path);
        if (tombstone) {
            this.fileHash.put(path, PathMetadata.tombstone(path));
        } else {
            this.fileHash.remove(path);
        }
        LOG.debug("removing listing of {}", (Object)path);
        this.dirHash.remove(path);
        Path parent = path.getParent();
        if (parent != null && (dir = (DirListingMetadata)this.dirHash.get(parent)) != null) {
            LOG.debug("removing parent's entry for {} ", (Object)path);
            if (tombstone) {
                dir.markDeleted(path);
            } else {
                dir.remove(path);
            }
        }
    }

    private Path standardize(Path p) {
        Preconditions.checkArgument(p.isAbsolute(), "Path must be absolute");
        URI uri = p.toUri();
        if (this.uriHost != null) {
            Preconditions.checkArgument(StringUtils.isNotEmpty(uri.getHost()));
        }
        return p;
    }

    @Override
    public Map<String, String> getDiagnostics() throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", "local://metadata");
        map.put("uriHost", this.uriHost);
        map.put("description", "Local in-VM metadata store for testing");
        return map;
    }

    @Override
    public void updateParameters(Map<String, String> parameters) throws IOException {
    }
}

