/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit.files;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.commit.ValidationFailure;
import org.apache.hadoop.fs.s3a.commit.files.PersistentCommitData;
import org.apache.hadoop.util.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SuccessData
extends PersistentCommitData {
    private static final Logger LOG = LoggerFactory.getLogger(SuccessData.class);
    private static final long serialVersionUID = 507133045258460084L;
    public static final String NAME = "org.apache.hadoop.fs.s3a.commit.files.SuccessData/1";
    private String name;
    private long timestamp;
    private String date;
    private String hostname;
    private String committer;
    private String description;
    private Map<String, Long> metrics = new HashMap<String, Long>();
    private Map<String, String> diagnostics = new HashMap<String, String>();
    private List<String> filenames = new ArrayList<String>(0);

    @Override
    public void validate() throws ValidationFailure {
        ValidationFailure.verify(this.name != null, "Incompatible file format: no 'name' field", new Object[0]);
        ValidationFailure.verify(NAME.equals(this.name), "Incompatible file format: " + this.name, new Object[0]);
    }

    @Override
    public byte[] toBytes() throws IOException {
        return SuccessData.serializer().toBytes(this);
    }

    @Override
    public void save(FileSystem fs, Path path, boolean overwrite) throws IOException {
        this.name = NAME;
        SuccessData.serializer().save(fs, path, this, overwrite);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SuccessData{");
        sb.append("committer='").append(this.committer).append('\'');
        sb.append(", hostname='").append(this.hostname).append('\'');
        sb.append(", description='").append(this.description).append('\'');
        sb.append(", date='").append(this.date).append('\'');
        sb.append(", filenames=[").append(StringUtils.join(this.filenames, ", ")).append("]");
        sb.append('}');
        return sb.toString();
    }

    public String dumpMetrics(String prefix, String middle, String suffix) {
        return SuccessData.joinMap(this.metrics, prefix, middle, suffix);
    }

    public String dumpDiagnostics(String prefix, String middle, String suffix) {
        return SuccessData.joinMap(this.diagnostics, prefix, middle, suffix);
    }

    protected static String joinMap(Map<String, ?> map, String prefix, String middle, String suffix) {
        if (map == null) {
            return "";
        }
        ArrayList<String> list = new ArrayList<String>(map.keySet());
        Collections.sort(list);
        StringBuilder sb = new StringBuilder(list.size() * 32);
        for (String k : list) {
            sb.append(prefix).append(k).append(middle).append(map.get(k)).append(suffix);
        }
        return sb.toString();
    }

    public static SuccessData load(FileSystem fs, Path path) throws IOException {
        LOG.debug("Reading success data from {}", (Object)path);
        SuccessData instance = SuccessData.serializer().load(fs, path);
        instance.validate();
        return instance;
    }

    private static JsonSerialization<SuccessData> serializer() {
        return new JsonSerialization<SuccessData>(SuccessData.class, false, true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Long> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Long> metrics) {
        this.metrics = metrics;
    }

    public List<String> getFilenames() {
        return this.filenames;
    }

    public void setFilenames(List<String> filenames) {
        this.filenames = filenames;
    }

    public Map<String, String> getDiagnostics() {
        return this.diagnostics;
    }

    public void setDiagnostics(Map<String, String> diagnostics) {
        this.diagnostics = diagnostics;
    }

    public void addDiagnostic(String key, String value) {
        this.diagnostics.put(key, value);
    }
}

