/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.airlift.stats.Distribution;
import io.airlift.stats.ExponentialDecay;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class DistributionStat {
    private final Distribution oneMinute = new Distribution(ExponentialDecay.oneMinute());
    private final Distribution fiveMinutes = new Distribution(ExponentialDecay.fiveMinutes());
    private final Distribution fifteenMinutes = new Distribution(ExponentialDecay.fifteenMinutes());
    private final Distribution allTime = new Distribution();

    public void add(long value) {
        this.oneMinute.add(value);
        this.fiveMinutes.add(value);
        this.fifteenMinutes.add(value);
        this.allTime.add(value);
    }

    @Managed
    @Nested
    public Distribution getOneMinute() {
        return this.oneMinute;
    }

    @Managed
    @Nested
    public Distribution getFiveMinutes() {
        return this.fiveMinutes;
    }

    @Managed
    @Nested
    public Distribution getFifteenMinutes() {
        return this.fifteenMinutes;
    }

    @Managed
    @Nested
    public Distribution getAllTime() {
        return this.allTime;
    }

    public DistributionStatSnapshot snapshot() {
        return new DistributionStatSnapshot(this.getOneMinute().snapshot(), this.getFiveMinutes().snapshot(), this.getFifteenMinutes().snapshot(), this.getAllTime().snapshot());
    }

    public static class DistributionStatSnapshot {
        private final Distribution.DistributionSnapshot oneMinute;
        private final Distribution.DistributionSnapshot fiveMinute;
        private final Distribution.DistributionSnapshot fifteenMinute;
        private final Distribution.DistributionSnapshot allTime;

        @JsonCreator
        public DistributionStatSnapshot(@JsonProperty(value="oneMinute") Distribution.DistributionSnapshot oneMinute, @JsonProperty(value="fiveMinute") Distribution.DistributionSnapshot fiveMinute, @JsonProperty(value="fifteenMinute") Distribution.DistributionSnapshot fifteenMinute, @JsonProperty(value="allTime") Distribution.DistributionSnapshot allTime) {
            this.oneMinute = oneMinute;
            this.fiveMinute = fiveMinute;
            this.fifteenMinute = fifteenMinute;
            this.allTime = allTime;
        }

        @JsonProperty
        public Distribution.DistributionSnapshot getOneMinute() {
            return this.oneMinute;
        }

        @JsonProperty
        public Distribution.DistributionSnapshot getFiveMinutes() {
            return this.fiveMinute;
        }

        @JsonProperty
        public Distribution.DistributionSnapshot getFifteenMinutes() {
            return this.fifteenMinute;
        }

        @JsonProperty
        public Distribution.DistributionSnapshot getAllTime() {
            return this.allTime;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("oneMinute", this.oneMinute).add("fiveMinute", this.fiveMinute).add("fifteenMinute", this.fifteenMinute).add("allTime", this.allTime).toString();
        }
    }
}

