/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.statistics;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HivePartition;
import com.facebook.presto.hive.HiveSessionProperties;
import com.facebook.presto.hive.HiveTableHandle;
import com.facebook.presto.hive.PartitionStatistics;
import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.facebook.presto.hive.metastore.Partition;
import com.facebook.presto.hive.metastore.SemiTransactionalHiveMetastore;
import com.facebook.presto.hive.metastore.Table;
import com.facebook.presto.hive.statistics.HiveStatisticsProvider;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.Estimate;
import com.facebook.presto.spi.statistics.RangeColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import javax.annotation.Nullable;

public class MetastoreHiveStatisticsProvider
implements HiveStatisticsProvider {
    private final TypeManager typeManager;
    private final SemiTransactionalHiveMetastore metastore;

    public MetastoreHiveStatisticsProvider(TypeManager typeManager, SemiTransactionalHiveMetastore metastore) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.metastore = Objects.requireNonNull(metastore, "metastore is null");
    }

    @Override
    public TableStatistics getTableStatistics(ConnectorSession session, ConnectorTableHandle tableHandle, List<HivePartition> hivePartitions, Map<String, ColumnHandle> tableColumns) {
        if (!HiveSessionProperties.isStatisticsEnabled(session)) {
            return TableStatistics.EMPTY_STATISTICS;
        }
        Map<String, PartitionStatistics> partitionStatistics = this.getPartitionsStatistics((HiveTableHandle)tableHandle, hivePartitions, tableColumns.keySet());
        TableStatistics.Builder tableStatistics = TableStatistics.builder();
        Estimate rowCount = this.calculateRowsCount(partitionStatistics);
        tableStatistics.setRowCount(rowCount);
        for (Map.Entry<String, ColumnHandle> columnEntry : tableColumns.entrySet()) {
            Estimate nullsFraction;
            String columnName = columnEntry.getKey();
            HiveColumnHandle hiveColumnHandle = (HiveColumnHandle)columnEntry.getValue();
            RangeColumnStatistics.Builder rangeStatistics = RangeColumnStatistics.builder();
            if (hiveColumnHandle.isPartitionKey()) {
                rangeStatistics.setDistinctValuesCount(this.countDistinctPartitionKeys(hiveColumnHandle, hivePartitions));
                nullsFraction = this.calculateNullsFractionForPartitioningKey(hiveColumnHandle, hivePartitions, partitionStatistics);
            } else {
                rangeStatistics.setDistinctValuesCount(this.calculateDistinctValuesCount(partitionStatistics, columnName));
                nullsFraction = this.calculateNullsFraction(partitionStatistics, columnName, rowCount);
            }
            rangeStatistics.setFraction(nullsFraction.map(value -> 1.0 - value));
            ColumnStatistics.Builder columnStatistics = ColumnStatistics.builder();
            columnStatistics.setNullsFraction(nullsFraction);
            columnStatistics.addRange(rangeStatistics.build());
            tableStatistics.setColumnStatistics((ColumnHandle)hiveColumnHandle, columnStatistics.build());
        }
        return tableStatistics.build();
    }

    private Estimate calculateRowsCount(Map<String, PartitionStatistics> partitionStatistics) {
        List knownPartitionRowCounts = partitionStatistics.values().stream().map(PartitionStatistics::getRowCount).filter(OptionalLong::isPresent).map(OptionalLong::getAsLong).collect(Collectors.toList());
        long knownPartitionRowCountsSum = knownPartitionRowCounts.stream().mapToLong(a -> a).sum();
        long partitionsWithStatsCount = knownPartitionRowCounts.size();
        long allPartitionsCount = partitionStatistics.size();
        if (partitionsWithStatsCount == 0L) {
            return Estimate.unknownValue();
        }
        return new Estimate(1.0 * (double)knownPartitionRowCountsSum / (double)partitionsWithStatsCount * (double)allPartitionsCount);
    }

    private Estimate calculateDistinctValuesCount(Map<String, PartitionStatistics> statisticsByPartitionName, String column) {
        return this.summarizePartitionStatistics(statisticsByPartitionName.values(), column, columnStatistics -> {
            if (columnStatistics.getDistinctValuesCount().isPresent()) {
                return OptionalDouble.of(columnStatistics.getDistinctValuesCount().getAsLong());
            }
            return OptionalDouble.empty();
        }, DoubleStream::max);
    }

    private Estimate calculateNullsFraction(Map<String, PartitionStatistics> statisticsByPartitionName, String column, Estimate totalRowsCount) {
        Estimate totalNullsCount = this.summarizePartitionStatistics(statisticsByPartitionName.values(), column, columnStatistics -> {
            if (columnStatistics.getNullsCount().isPresent()) {
                return OptionalDouble.of(columnStatistics.getNullsCount().getAsLong());
            }
            return OptionalDouble.empty();
        }, nullsCountStream -> {
            double nullsCount = 0.0;
            long partitionsWithStatisticsCount = 0L;
            PrimitiveIterator.OfDouble nullsCountIterator = nullsCountStream.iterator();
            while (nullsCountIterator.hasNext()) {
                nullsCount += nullsCountIterator.nextDouble();
                ++partitionsWithStatisticsCount;
            }
            if (partitionsWithStatisticsCount == 0L) {
                return OptionalDouble.empty();
            }
            int allPartitionsCount = statisticsByPartitionName.size();
            return OptionalDouble.of((double)((long)allPartitionsCount / partitionsWithStatisticsCount) * nullsCount);
        });
        if (totalNullsCount.isValueUnknown() || totalRowsCount.isValueUnknown()) {
            return Estimate.unknownValue();
        }
        if (totalRowsCount.getValue() == 0.0) {
            return Estimate.zeroValue();
        }
        return new Estimate(totalNullsCount.getValue() / totalRowsCount.getValue());
    }

    private Estimate countDistinctPartitionKeys(HiveColumnHandle partitionColumn, List<HivePartition> partitions) {
        return new Estimate((double)partitions.stream().map(HivePartition::getKeys).map(keys -> (NullableValue)keys.get(partitionColumn)).distinct().count());
    }

    private Estimate calculateNullsFractionForPartitioningKey(HiveColumnHandle partitionColumn, List<HivePartition> partitions, Map<String, PartitionStatistics> partitionStatistics) {
        OptionalDouble rowsPerPartition = partitionStatistics.values().stream().map(PartitionStatistics::getRowCount).filter(OptionalLong::isPresent).mapToLong(OptionalLong::getAsLong).average();
        if (!rowsPerPartition.isPresent()) {
            return Estimate.unknownValue();
        }
        double estimatedTotalRowsCount = rowsPerPartition.getAsDouble() * (double)partitions.size();
        if (estimatedTotalRowsCount == 0.0) {
            return Estimate.zeroValue();
        }
        double estimatedNullsCount = partitions.stream().filter(partition -> partition.getKeys().get(partitionColumn).isNull()).map(HivePartition::getPartitionId).mapToLong(partitionId -> ((PartitionStatistics)partitionStatistics.get(partitionId)).getRowCount().orElse((long)rowsPerPartition.getAsDouble())).sum();
        return new Estimate(estimatedNullsCount / estimatedTotalRowsCount);
    }

    private Estimate summarizePartitionStatistics(Collection<PartitionStatistics> partitionStatistics, String column, Function<HiveColumnStatistics, OptionalDouble> valueExtractFunction, Function<DoubleStream, OptionalDouble> valueAggregateFunction) {
        DoubleStream intermediateStream = partitionStatistics.stream().map(PartitionStatistics::getColumnStatistics).filter(stats -> stats.containsKey(column)).map(stats -> (HiveColumnStatistics)stats.get(column)).map(valueExtractFunction).filter(OptionalDouble::isPresent).mapToDouble(OptionalDouble::getAsDouble);
        OptionalDouble statisticsValue = valueAggregateFunction.apply(intermediateStream);
        if (statisticsValue.isPresent()) {
            return new Estimate(statisticsValue.getAsDouble());
        }
        return Estimate.unknownValue();
    }

    private Map<String, PartitionStatistics> getPartitionsStatistics(HiveTableHandle tableHandle, List<HivePartition> hivePartitions, Set<String> tableColumns) {
        if (hivePartitions.isEmpty()) {
            return ImmutableMap.of();
        }
        boolean unpartitioned = hivePartitions.stream().anyMatch(partition -> partition.getPartitionId().equals("<UNPARTITIONED>"));
        if (unpartitioned) {
            Preconditions.checkArgument(hivePartitions.size() == 1, "expected only one hive partition");
        }
        if (unpartitioned) {
            return ImmutableMap.of("<UNPARTITIONED>", this.getTableStatistics(tableHandle.getSchemaTableName(), tableColumns));
        }
        return this.getPartitionsStatistics(tableHandle.getSchemaTableName(), hivePartitions, tableColumns);
    }

    private Map<String, PartitionStatistics> getPartitionsStatistics(SchemaTableName schemaTableName, List<HivePartition> hivePartitions, Set<String> tableColumns) {
        String databaseName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        ImmutableMap.Builder<String, PartitionStatistics> resultMap = ImmutableMap.builder();
        List<String> partitionNames = hivePartitions.stream().map(HivePartition::getPartitionId).collect(Collectors.toList());
        Map partitionColumnStatisticsMap = this.metastore.getPartitionColumnStatistics(databaseName, tableName, new HashSet<String>(partitionNames), tableColumns).orElse(ImmutableMap.of());
        Map<String, Optional<Partition>> partitionsByNames = this.metastore.getPartitionsByNames(databaseName, tableName, partitionNames);
        for (String partitionName : partitionNames) {
            Map partitionParameters = partitionsByNames.get(partitionName).map(Partition::getParameters).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get metadata for partition %s.%s.%s", databaseName, tableName, partitionName)));
            Map partitionColumnStatistics = partitionColumnStatisticsMap.getOrDefault(partitionName, ImmutableMap.of());
            resultMap.put(partitionName, this.readStatisticsFromParameters(partitionParameters, partitionColumnStatistics));
        }
        return resultMap.build();
    }

    private PartitionStatistics getTableStatistics(SchemaTableName schemaTableName, Set<String> tableColumns) {
        String databaseName = schemaTableName.getSchemaName();
        String tableName = schemaTableName.getTableName();
        Table table = this.metastore.getTable(databaseName, tableName).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get metadata for table %s.%s", databaseName, tableName)));
        Map tableColumnStatistics = this.metastore.getTableColumnStatistics(databaseName, tableName, tableColumns).orElse(ImmutableMap.of());
        return this.readStatisticsFromParameters(table.getParameters(), tableColumnStatistics);
    }

    private PartitionStatistics readStatisticsFromParameters(Map<String, String> parameters, Map<String, HiveColumnStatistics> columnStatistics) {
        boolean columnStatsAcurate = Boolean.valueOf(Optional.ofNullable(parameters.get("COLUMN_STATS_ACCURATE")).orElse("false"));
        OptionalLong numFiles = this.convertStringParameter(parameters.get("numFiles"));
        OptionalLong numRows = this.convertStringParameter(parameters.get("numRows"));
        OptionalLong rawDataSize = this.convertStringParameter(parameters.get("rawDataSize"));
        OptionalLong totalSize = this.convertStringParameter(parameters.get("totalSize"));
        return new PartitionStatistics(columnStatsAcurate, numFiles, numRows, rawDataSize, totalSize, columnStatistics);
    }

    private OptionalLong convertStringParameter(@Nullable String parameterValue) {
        if (parameterValue == null) {
            return OptionalLong.empty();
        }
        try {
            long longValue = Long.parseLong(parameterValue);
            if (longValue < 0L) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(longValue);
        }
        catch (NumberFormatException e) {
            return OptionalLong.empty();
        }
    }

    private ColumnMetadata getColumnMetadata(ColumnHandle columnHandle) {
        return ((HiveColumnHandle)columnHandle).getColumnMetadata(this.typeManager);
    }
}

