/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.dictionary;

import com.facebook.presto.hive.parquet.ParquetDictionaryPage;
import com.facebook.presto.hive.parquet.dictionary.ParquetDictionary;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.IOException;
import parquet.bytes.BytesUtils;
import parquet.io.api.Binary;

public class ParquetBinaryDictionary
extends ParquetDictionary {
    private final Binary[] content;

    public ParquetBinaryDictionary(ParquetDictionaryPage dictionaryPage) throws IOException {
        this(dictionaryPage, null);
    }

    public ParquetBinaryDictionary(ParquetDictionaryPage dictionaryPage, Integer length) throws IOException {
        super(dictionaryPage.getEncoding());
        byte[] dictionaryBytes = dictionaryPage.getSlice().getBytes();
        this.content = new Binary[dictionaryPage.getDictionarySize()];
        int offset = 0;
        if (length == null) {
            for (int i = 0; i < this.content.length; ++i) {
                int len = BytesUtils.readIntLittleEndian((byte[])dictionaryBytes, (int)offset);
                this.content[i] = Binary.fromByteArray((byte[])dictionaryBytes, (int)(offset += 4), (int)len);
                offset += len;
            }
        } else {
            Preconditions.checkArgument(length > 0, "Invalid byte array length: %s", (Object)length);
            for (int i = 0; i < this.content.length; ++i) {
                this.content[i] = Binary.fromByteArray((byte[])dictionaryBytes, (int)offset, (int)length);
                offset += length.intValue();
            }
        }
    }

    @Override
    public Binary decodeToBinary(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("content", this.content).toString();
    }
}

