/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.StandardErrorCode;

public class TableAlreadyExistsException
extends PrestoException {
    private final SchemaTableName tableName;

    public TableAlreadyExistsException(SchemaTableName tableName) {
        this(tableName, String.format("Table already exists: '%s'", tableName));
    }

    public TableAlreadyExistsException(SchemaTableName tableName, String message) {
        this(tableName, message, null);
    }

    public TableAlreadyExistsException(SchemaTableName tableName, String message, Throwable cause) {
        super((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, message, cause);
        this.tableName = tableName;
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }
}

