/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import io.airlift.units.Duration;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.TimeUnit;

@Beta
public class CpuTimer {
    private static final ThreadMXBean THREAD_MX_BEAN = ManagementFactory.getThreadMXBean();
    private final long wallStartTime = System.nanoTime();
    private final long cpuStartTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
    private final long userStartTime = THREAD_MX_BEAN.getCurrentThreadUserTime();
    private long intervalWallStart = this.wallStartTime;
    private long intervalCpuStart = this.cpuStartTime;
    private long intervalUserStart = this.userStartTime;

    public CpuDuration startNewInterval() {
        long currentWallTime = System.nanoTime();
        long currentCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        long currentUserTime = THREAD_MX_BEAN.getCurrentThreadUserTime();
        CpuDuration cpuDuration = new CpuDuration(CpuTimer.nanosBetween(this.intervalWallStart, currentWallTime), CpuTimer.nanosBetween(this.intervalCpuStart, currentCpuTime), CpuTimer.nanosBetween(this.intervalUserStart, currentUserTime));
        this.intervalWallStart = currentWallTime;
        this.intervalCpuStart = currentCpuTime;
        this.intervalUserStart = currentUserTime;
        return cpuDuration;
    }

    public CpuDuration elapsedIntervalTime() {
        long currentWallTime = System.nanoTime();
        long currentCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        long currentUserTime = THREAD_MX_BEAN.getCurrentThreadUserTime();
        return new CpuDuration(CpuTimer.nanosBetween(this.intervalWallStart, currentWallTime), CpuTimer.nanosBetween(this.intervalCpuStart, currentCpuTime), CpuTimer.nanosBetween(this.intervalUserStart, currentUserTime));
    }

    public CpuDuration elapsedTime() {
        long currentWallTime = System.nanoTime();
        long currentCpuTime = THREAD_MX_BEAN.getCurrentThreadCpuTime();
        long currentUserTime = THREAD_MX_BEAN.getCurrentThreadUserTime();
        return new CpuDuration(CpuTimer.nanosBetween(this.wallStartTime, currentWallTime), CpuTimer.nanosBetween(this.cpuStartTime, currentCpuTime), CpuTimer.nanosBetween(this.userStartTime, currentUserTime));
    }

    private static Duration nanosBetween(long start, long end) {
        return new Duration(Math.abs(end - start), TimeUnit.NANOSECONDS);
    }

    public static class CpuDuration {
        private final Duration wall;
        private final Duration cpu;
        private final Duration user;

        public CpuDuration() {
            this.wall = new Duration(0.0, TimeUnit.NANOSECONDS);
            this.cpu = new Duration(0.0, TimeUnit.NANOSECONDS);
            this.user = new Duration(0.0, TimeUnit.NANOSECONDS);
        }

        public CpuDuration(Duration wall, Duration cpu, Duration user) {
            this.wall = wall;
            this.cpu = cpu;
            this.user = user;
        }

        public Duration getWall() {
            return this.wall;
        }

        public Duration getCpu() {
            return this.cpu;
        }

        public Duration getUser() {
            return this.user;
        }

        public CpuDuration add(CpuDuration cpuDuration) {
            return new CpuDuration(CpuDuration.addDurations(this.wall, cpuDuration.wall), CpuDuration.addDurations(this.cpu, cpuDuration.cpu), CpuDuration.addDurations(this.user, cpuDuration.user));
        }

        public CpuDuration subtract(CpuDuration cpuDuration) {
            return new CpuDuration(CpuDuration.subtractDurations(this.wall, cpuDuration.wall), CpuDuration.subtractDurations(this.cpu, cpuDuration.cpu), CpuDuration.subtractDurations(this.user, cpuDuration.user));
        }

        private static Duration addDurations(Duration a, Duration b) {
            return new Duration(a.getValue(TimeUnit.NANOSECONDS) + b.getValue(TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS);
        }

        private static Duration subtractDurations(Duration a, Duration b) {
            return new Duration(Math.max(0.0, a.getValue(TimeUnit.NANOSECONDS) - b.getValue(TimeUnit.NANOSECONDS)), TimeUnit.NANOSECONDS);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("wall", this.wall).add("cpu", this.cpu).add("user", this.user).toString();
        }
    }
}

