/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.rcfile;

import com.facebook.presto.hive.FileFormatDataSourceStats;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HivePageSourceFactory;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.hive.rcfile.HdfsRcFileDataSource;
import com.facebook.presto.hive.rcfile.RcFilePageSource;
import com.facebook.presto.rcfile.AircompressorCodecFactory;
import com.facebook.presto.rcfile.HadoopCodecFactory;
import com.facebook.presto.rcfile.RcFileCodecFactory;
import com.facebook.presto.rcfile.RcFileCorruptionException;
import com.facebook.presto.rcfile.RcFileDataSource;
import com.facebook.presto.rcfile.RcFileEncoding;
import com.facebook.presto.rcfile.RcFileReader;
import com.facebook.presto.rcfile.binary.BinaryRcFileEncoding;
import com.facebook.presto.rcfile.text.TextRcFileEncoding;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.joda.time.DateTimeZone;

public class RcFilePageSourceFactory
implements HivePageSourceFactory {
    private static final int TEXT_LEGACY_NESTING_LEVELS = 8;
    private static final int TEXT_EXTENDED_NESTING_LEVELS = 29;
    private final TypeManager typeManager;
    private final HdfsEnvironment hdfsEnvironment;
    private final FileFormatDataSourceStats stats;

    @Inject
    public RcFilePageSourceFactory(TypeManager typeManager, HdfsEnvironment hdfsEnvironment, FileFormatDataSourceStats stats) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.hdfsEnvironment = Objects.requireNonNull(hdfsEnvironment, "hdfsEnvironment is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    @Override
    public Optional<? extends ConnectorPageSource> createPageSource(Configuration configuration, ConnectorSession session, Path path, long start, long length, long fileSize, Properties schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone hiveStorageTimeZone) {
        FSDataInputStream inputStream;
        BinaryRcFileEncoding rcFileEncoding;
        String deserializerClassName = HiveUtil.getDeserializerClassName(schema);
        if (deserializerClassName.equals(LazyBinaryColumnarSerDe.class.getName())) {
            rcFileEncoding = new BinaryRcFileEncoding();
        } else if (deserializerClassName.equals(ColumnarSerDe.class.getName())) {
            rcFileEncoding = RcFilePageSourceFactory.createTextVectorEncoding(schema, hiveStorageTimeZone);
        } else {
            return Optional.empty();
        }
        try {
            FileSystem fileSystem = this.hdfsEnvironment.getFileSystem(session.getUser(), path, configuration);
            inputStream = fileSystem.open(path);
        }
        catch (Exception e) {
            if (Strings.nullToEmpty(e.getMessage()).trim().equals("Filesystem closed") || e instanceof FileNotFoundException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, (Throwable)e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, RcFilePageSourceFactory.splitError(e, path, start, length), (Throwable)e);
        }
        try {
            ImmutableMap.Builder<Integer, Type> readColumns = ImmutableMap.builder();
            for (HiveColumnHandle column : columns) {
                readColumns.put(column.getHiveColumnIndex(), column.getHiveType().getType(this.typeManager));
            }
            RcFileReader rcFileReader = new RcFileReader((RcFileDataSource)new HdfsRcFileDataSource(path.toString(), inputStream, fileSize, this.stats), (RcFileEncoding)rcFileEncoding, readColumns.build(), (RcFileCodecFactory)new AircompressorCodecFactory((RcFileCodecFactory)new HadoopCodecFactory(configuration.getClassLoader())), start, length, new DataSize(8.0, DataSize.Unit.MEGABYTE));
            return Optional.of(new RcFilePageSource(rcFileReader, columns, hiveStorageTimeZone, this.typeManager));
        }
        catch (Throwable e) {
            try {
                inputStream.close();
            }
            catch (IOException rcFileReader) {
                // empty catch block
            }
            if (e instanceof PrestoException) {
                throw (PrestoException)e;
            }
            String message = RcFilePageSourceFactory.splitError(e, path, start, length);
            if (e instanceof RcFileCorruptionException) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, message, e);
            }
            if (e.getClass().getSimpleName().equals("BlockMissingException")) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_MISSING_DATA, message, e);
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, e);
        }
    }

    private static String splitError(Throwable t, Path path, long start, long length) {
        return String.format("Error opening Hive split %s (offset=%s, length=%s): %s", path, start, length, t.getMessage());
    }

    public static TextRcFileEncoding createTextVectorEncoding(Properties schema, DateTimeZone hiveStorageTimeZone) {
        int nestingLevels = !"true".equalsIgnoreCase(schema.getProperty("hive.serialization.extend.nesting.levels")) ? 8 : 29;
        byte[] separators = Arrays.copyOf(TextRcFileEncoding.DEFAULT_SEPARATORS, nestingLevels);
        separators[0] = LazyUtils.getByte((String)schema.getProperty("field.delim", schema.getProperty("serialization.format")), (byte)TextRcFileEncoding.DEFAULT_SEPARATORS[0]);
        separators[1] = LazyUtils.getByte((String)schema.getProperty("colelction.delim"), (byte)TextRcFileEncoding.DEFAULT_SEPARATORS[1]);
        separators[2] = LazyUtils.getByte((String)schema.getProperty("mapkey.delim"), (byte)TextRcFileEncoding.DEFAULT_SEPARATORS[2]);
        String nullSequenceString = schema.getProperty("serialization.null.format");
        Slice nullSequence = nullSequenceString == null ? TextRcFileEncoding.DEFAULT_NULL_SEQUENCE : Slices.utf8Slice(nullSequenceString);
        String lastColumnTakesRestString = schema.getProperty("serialization.last.column.takes.rest");
        boolean lastColumnTakesRest = "true".equalsIgnoreCase(lastColumnTakesRestString);
        String escapeProperty = schema.getProperty("escape.delim");
        Byte escapeByte = null;
        if (escapeProperty != null) {
            escapeByte = LazyUtils.getByte((String)escapeProperty, (byte)92);
        }
        return new TextRcFileEncoding(hiveStorageTimeZone, nullSequence, separators, escapeByte, lastColumnTakesRest);
    }
}

