/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.parquet.ParquetDictionaryPage;
import com.facebook.presto.hive.parquet.ParquetValuesType;
import com.facebook.presto.hive.parquet.dictionary.ParquetBinaryDictionary;
import com.facebook.presto.hive.parquet.dictionary.ParquetDictionary;
import com.facebook.presto.hive.parquet.dictionary.ParquetDictionaryReader;
import com.facebook.presto.hive.parquet.dictionary.ParquetDoubleDictionary;
import com.facebook.presto.hive.parquet.dictionary.ParquetFloatDictionary;
import com.facebook.presto.hive.parquet.dictionary.ParquetIntegerDictionary;
import com.facebook.presto.hive.parquet.dictionary.ParquetLongDictionary;
import com.google.common.base.Preconditions;
import java.io.IOException;
import parquet.bytes.BytesUtils;
import parquet.column.ColumnDescriptor;
import parquet.column.values.ValuesReader;
import parquet.column.values.bitpacking.ByteBitPackingValuesReader;
import parquet.column.values.bitpacking.Packer;
import parquet.column.values.boundedint.ZeroIntegerValuesReader;
import parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import parquet.column.values.deltalengthbytearray.DeltaLengthByteArrayValuesReader;
import parquet.column.values.deltastrings.DeltaByteArrayReader;
import parquet.column.values.plain.BinaryPlainValuesReader;
import parquet.column.values.plain.BooleanPlainValuesReader;
import parquet.column.values.plain.FixedLenByteArrayPlainValuesReader;
import parquet.column.values.plain.PlainValuesReader;
import parquet.column.values.rle.RunLengthBitPackingHybridValuesReader;
import parquet.io.ParquetDecodingException;
import parquet.schema.PrimitiveType;

public enum ParquetEncoding {
    PLAIN{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType) {
            switch (descriptor.getType()) {
                case BOOLEAN: {
                    return new BooleanPlainValuesReader();
                }
                case BINARY: {
                    return new BinaryPlainValuesReader();
                }
                case FLOAT: {
                    return new PlainValuesReader.FloatPlainValuesReader();
                }
                case DOUBLE: {
                    return new PlainValuesReader.DoublePlainValuesReader();
                }
                case INT32: {
                    return new PlainValuesReader.IntegerPlainValuesReader();
                }
                case INT64: {
                    return new PlainValuesReader.LongPlainValuesReader();
                }
                case INT96: {
                    return new FixedLenByteArrayPlainValuesReader(12);
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    return new FixedLenByteArrayPlainValuesReader(descriptor.getTypeLength());
                }
            }
            throw new ParquetDecodingException("Plain values reader does not support: " + descriptor.getType());
        }

        @Override
        public ParquetDictionary initDictionary(ColumnDescriptor descriptor, ParquetDictionaryPage dictionaryPage) throws IOException {
            switch (descriptor.getType()) {
                case BINARY: {
                    return new ParquetBinaryDictionary(dictionaryPage);
                }
                case FIXED_LEN_BYTE_ARRAY: {
                    return new ParquetBinaryDictionary(dictionaryPage, descriptor.getTypeLength());
                }
                case INT96: {
                    return new ParquetBinaryDictionary(dictionaryPage, 12);
                }
                case INT64: {
                    return new ParquetLongDictionary(dictionaryPage);
                }
                case DOUBLE: {
                    return new ParquetDoubleDictionary(dictionaryPage);
                }
                case INT32: {
                    return new ParquetIntegerDictionary(dictionaryPage);
                }
                case FLOAT: {
                    return new ParquetFloatDictionary(dictionaryPage);
                }
            }
            throw new ParquetDecodingException("Dictionary encoding does not support: " + descriptor.getType());
        }
    }
    ,
    RLE{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType) {
            int bitWidth = BytesUtils.getWidthFromMaxInt((int)2.getMaxLevel(descriptor, valuesType));
            if (bitWidth == 0) {
                return new ZeroIntegerValuesReader();
            }
            return new RunLengthBitPackingHybridValuesReader(bitWidth);
        }
    }
    ,
    BIT_PACKED{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType) {
            return new ByteBitPackingValuesReader(3.getMaxLevel(descriptor, valuesType), Packer.BIG_ENDIAN);
        }
    }
    ,
    PLAIN_DICTIONARY{

        @Override
        public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType, ParquetDictionary dictionary) {
            return RLE_DICTIONARY.getDictionaryBasedValuesReader(descriptor, valuesType, dictionary);
        }

        @Override
        public ParquetDictionary initDictionary(ColumnDescriptor descriptor, ParquetDictionaryPage dictionaryPage) throws IOException {
            return PLAIN.initDictionary(descriptor, dictionaryPage);
        }

        @Override
        public boolean usesDictionary() {
            return true;
        }
    }
    ,
    DELTA_BINARY_PACKED{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType) {
            Preconditions.checkArgument(descriptor.getType() == PrimitiveType.PrimitiveTypeName.INT32, "Encoding DELTA_BINARY_PACKED is only supported for type INT32");
            return new DeltaBinaryPackingValuesReader();
        }
    }
    ,
    DELTA_LENGTH_BYTE_ARRAY{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType) {
            Preconditions.checkArgument(descriptor.getType() == PrimitiveType.PrimitiveTypeName.BINARY, "Encoding DELTA_LENGTH_BYTE_ARRAY is only supported for type BINARY");
            return new DeltaLengthByteArrayValuesReader();
        }
    }
    ,
    DELTA_BYTE_ARRAY{

        @Override
        public ValuesReader getValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType) {
            Preconditions.checkArgument(descriptor.getType() == PrimitiveType.PrimitiveTypeName.BINARY || descriptor.getType() == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, "Encoding DELTA_BYTE_ARRAY is only supported for type BINARY and FIXED_LEN_BYTE_ARRAY");
            return new DeltaByteArrayReader();
        }
    }
    ,
    RLE_DICTIONARY{

        @Override
        public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType, ParquetDictionary dictionary) {
            return new ParquetDictionaryReader(dictionary);
        }

        @Override
        public ParquetDictionary initDictionary(ColumnDescriptor descriptor, ParquetDictionaryPage dictionaryPage) throws IOException {
            return PLAIN.initDictionary(descriptor, dictionaryPage);
        }

        @Override
        public boolean usesDictionary() {
            return true;
        }
    };

    static final int INT96_TYPE_LENGTH = 12;

    static int getMaxLevel(ColumnDescriptor descriptor, ParquetValuesType valuesType) {
        switch (valuesType) {
            case REPETITION_LEVEL: {
                return descriptor.getMaxRepetitionLevel();
            }
            case DEFINITION_LEVEL: {
                return descriptor.getMaxDefinitionLevel();
            }
            case VALUES: {
                if (descriptor.getType() != PrimitiveType.PrimitiveTypeName.BOOLEAN) break;
                return 1;
            }
        }
        throw new ParquetDecodingException("Unsupported Parquet values type: " + (Object)((Object)valuesType));
    }

    public boolean usesDictionary() {
        return false;
    }

    public ParquetDictionary initDictionary(ColumnDescriptor descriptor, ParquetDictionaryPage dictionaryPage) throws IOException {
        throw new UnsupportedOperationException("Parquet Dictionary encoding is not supported for: " + this.name());
    }

    public ValuesReader getValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType) {
        throw new UnsupportedOperationException("Error decoding Parquet values in encoding: " + this.name());
    }

    public ValuesReader getDictionaryBasedValuesReader(ColumnDescriptor descriptor, ParquetValuesType valuesType, ParquetDictionary dictionary) {
        throw new UnsupportedOperationException("Parquet Dictionary encoding is not supported for: " + this.name());
    }
}

