/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.s3a.s3guard.DirListingMetadata;
import org.apache.hadoop.fs.s3a.s3guard.MetadataStore;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DescendantsIterator
implements RemoteIterator<FileStatus> {
    private final MetadataStore metadataStore;
    private final Queue<PathMetadata> queue = new LinkedList<PathMetadata>();

    public DescendantsIterator(MetadataStore ms, PathMetadata meta) throws IOException {
        Preconditions.checkNotNull(ms);
        this.metadataStore = ms;
        if (meta != null) {
            Path path = meta.getFileStatus().getPath();
            if (path.isRoot()) {
                DirListingMetadata rootListing = ms.listChildren(path);
                if (rootListing != null) {
                    rootListing = rootListing.withoutTombstones();
                    this.queue.addAll(rootListing.getListing());
                }
            } else {
                this.queue.add(meta);
            }
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return !this.queue.isEmpty();
    }

    @Override
    public FileStatus next() throws IOException {
        Collection<PathMetadata> more;
        Path path;
        DirListingMetadata meta;
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more descendants.");
        }
        PathMetadata next = this.queue.poll();
        if (next.getFileStatus().isDirectory() && (meta = this.metadataStore.listChildren(path = next.getFileStatus().getPath())) != null && !(more = meta.withoutTombstones().getListing()).isEmpty()) {
            this.queue.addAll(more);
        }
        return next.getFileStatus();
    }
}

