/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.dictionary;

import com.facebook.presto.hive.parquet.ParquetDictionaryPage;
import com.facebook.presto.hive.parquet.dictionary.ParquetDictionary;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import parquet.column.values.plain.PlainValuesReader;

public class ParquetLongDictionary
extends ParquetDictionary {
    private final long[] content;

    public ParquetLongDictionary(ParquetDictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        this.content = new long[dictionaryPage.getDictionarySize()];
        PlainValuesReader.LongPlainValuesReader longReader = new PlainValuesReader.LongPlainValuesReader();
        longReader.initFromPage(dictionaryPage.getDictionarySize(), dictionaryPage.getSlice().getBytes(), 0);
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = longReader.readLong();
        }
    }

    @Override
    public long decodeToLong(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("content", this.content).toString();
    }
}

