/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;

public final class ExponentialDecay {
    private ExponentialDecay() {
    }

    public static double oneMinute() {
        return 1.0 / (double)TimeUnit.MINUTES.toSeconds(1L);
    }

    public static double fiveMinutes() {
        return 1.0 / (double)TimeUnit.MINUTES.toSeconds(5L);
    }

    public static double fifteenMinutes() {
        return 1.0 / (double)TimeUnit.MINUTES.toSeconds(15L);
    }

    public static double seconds(int seconds) {
        return 1.0 / (double)seconds;
    }

    public static double computeAlpha(double targetWeight, long targetAgeInSeconds) {
        Preconditions.checkArgument(targetAgeInSeconds > 0L, "targetAgeInSeconds must be > 0");
        Preconditions.checkArgument(targetWeight > 0.0 && targetWeight < 1.0, "targetWeight must be in range (0, 1)");
        return -Math.log(targetWeight) / (double)targetAgeInSeconds;
    }
}

