/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.AmazonClientException;
import com.amazonaws.SdkBaseException;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Invoker {
    private static final Logger LOG = LoggerFactory.getLogger(Invoker.class);
    private final RetryPolicy retryPolicy;
    private final Retried retryCallback;
    public static final Retried NO_OP = new Retried(){

        @Override
        public void onFailure(String text, IOException exception, int retries, boolean idempotent) {
        }
    };
    public static final Retried LOG_EVENT = new Retried(){

        @Override
        public void onFailure(String text, IOException exception, int retries, boolean idempotent) {
            LOG.debug("{}: " + exception, (Object)text);
            if (retries == 1) {
                LOG.debug("{}: " + exception, (Object)text, (Object)exception);
            }
        }
    };

    public Invoker(RetryPolicy retryPolicy, Retried retryCallback) {
        this.retryPolicy = retryPolicy;
        this.retryCallback = retryCallback;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public Retried getRetryCallback() {
        return this.retryCallback;
    }

    public static <T> T once(String action, String path, Operation<T> operation) throws IOException {
        try {
            return operation.execute();
        }
        catch (AmazonClientException e) {
            throw S3AUtils.translateException(action, path, (SdkBaseException)e);
        }
    }

    public static void once(String action, String path, VoidOperation operation) throws IOException {
        Invoker.once(action, path, () -> {
            operation.execute();
            return null;
        });
    }

    public static <T> void ignoreIOExceptions(Logger log, String action, String path, Operation<T> operation) {
        try {
            Invoker.once(action, path, operation);
        }
        catch (IOException e) {
            log.info("{}: {}", new Object[]{Invoker.toDescription(action, path), e.toString(), e});
        }
    }

    public static void ignoreIOExceptions(Logger log, String action, String path, VoidOperation operation) {
        Invoker.ignoreIOExceptions(log, action, path, () -> {
            operation.execute();
            return null;
        });
    }

    public void retry(String action, String path, boolean idempotent, Retried retrying, VoidOperation operation) throws IOException {
        this.retry(action, path, idempotent, retrying, () -> {
            operation.execute();
            return null;
        });
    }

    public void retry(String action, String path, boolean idempotent, VoidOperation operation) throws IOException {
        this.retry(action, path, idempotent, this.retryCallback, operation);
    }

    public <T> T retry(String action, @Nullable String path, boolean idempotent, Operation<T> operation) throws IOException {
        return this.retry(action, path, idempotent, this.retryCallback, operation);
    }

    public <T> T retry(String action, @Nullable String path, boolean idempotent, Retried retrying, Operation<T> operation) throws IOException {
        return (T)this.retryUntranslated(Invoker.toDescription(action, path), idempotent, retrying, () -> Invoker.once(action, path, operation));
    }

    public <T> T retryUntranslated(String text, boolean idempotent, Operation<T> operation) throws IOException {
        return this.retryUntranslated(text, idempotent, this.retryCallback, operation);
    }

    public <T> T retryUntranslated(String text, boolean idempotent, Retried retrying, Operation<T> operation) throws IOException {
        Preconditions.checkArgument(retrying != null, "null retrying argument");
        int retryCount = 0;
        while (true) {
            try {
                if (retryCount > 0) {
                    LOG.debug("retry #{}", (Object)retryCount);
                }
                return operation.execute();
            }
            catch (SdkBaseException | IOException e) {
                boolean shouldRetry;
                Exception caught = e;
                IOException translated = caught instanceof IOException ? (IOException)caught : S3AUtils.translateException(text, "", (SdkBaseException)caught);
                try {
                    RetryPolicy.RetryAction retryAction = this.retryPolicy.shouldRetry(translated, retryCount, 0, idempotent);
                    shouldRetry = retryAction.action.equals((Object)RetryPolicy.RetryAction.RETRY.action);
                    if (shouldRetry) {
                        retrying.onFailure(text, translated, retryCount, idempotent);
                        Thread.sleep(retryAction.delayMillis);
                    }
                    ++retryCount;
                    continue;
                }
                catch (InterruptedException e2) {
                    caught = new InterruptedIOException("Interrupted");
                    caught.initCause(e2);
                    shouldRetry = false;
                    Thread.currentThread().interrupt();
                    continue;
                }
                catch (Exception e3) {
                    LOG.warn("{}: exception in retry processing", (Object)text, (Object)e3);
                    shouldRetry = false;
                }
                if (shouldRetry) continue;
                if (caught instanceof IOException) {
                    throw (IOException)caught;
                }
                throw (SdkBaseException)caught;
            }
            break;
        }
    }

    public static void quietly(String action, String path, VoidOperation operation) {
        try {
            Invoker.once(action, path, operation);
        }
        catch (Exception e) {
            LOG.debug("Action {} failed", (Object)action, (Object)e);
        }
    }

    public static <T> Optional<T> quietlyEval(String action, String path, Operation<T> operation) {
        try {
            return Optional.of(Invoker.once(action, path, operation));
        }
        catch (Exception e) {
            LOG.debug("Action {} failed", (Object)action, (Object)e);
            return Optional.empty();
        }
    }

    private static String toDescription(String action, @Nullable String path) {
        return action + (StringUtils.isNotEmpty((CharSequence)path) ? " on " + path : "");
    }

    @FunctionalInterface
    public static interface Retried {
        public void onFailure(String var1, IOException var2, int var3, boolean var4);
    }

    @FunctionalInterface
    public static interface VoidOperation {
        public void execute() throws IOException;
    }

    @FunctionalInterface
    public static interface Operation<T> {
        public T execute() throws IOException;
    }
}

