/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.util;

import java.util.concurrent.CompletableFuture;

public interface ResumableTask {
    public TaskStatus process();

    public static class TaskStatus {
        private final boolean finished;
        private final CompletableFuture<?> continuationFuture;

        private TaskStatus(boolean finished, CompletableFuture<?> continuationFuture) {
            this.finished = finished;
            this.continuationFuture = continuationFuture;
        }

        public static TaskStatus finished() {
            return new TaskStatus(true, CompletableFuture.completedFuture(null));
        }

        public static TaskStatus continueOn(CompletableFuture<?> continuationFuture) {
            return new TaskStatus(false, continuationFuture);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public CompletableFuture<?> getContinuationFuture() {
            return this.continuationFuture;
        }
    }
}

