/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HdfsConfiguration;
import com.facebook.presto.hive.HdfsConfigurationUpdater;
import com.facebook.presto.hive.HdfsEnvironment;
import com.facebook.presto.hive.util.ConfigurationUtils;
import java.net.URI;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.hadoop.conf.Configuration;

public class HiveHdfsConfiguration
implements HdfsConfiguration {
    private static final Configuration INITIAL_CONFIGURATION;
    private final ThreadLocal<Configuration> hadoopConfiguration = new ThreadLocal<Configuration>(){

        @Override
        protected Configuration initialValue() {
            Configuration configuration = new Configuration(false);
            ConfigurationUtils.copy(INITIAL_CONFIGURATION, configuration);
            HiveHdfsConfiguration.this.updater.updateConfiguration(configuration);
            return configuration;
        }
    };
    private final HdfsConfigurationUpdater updater;

    @Inject
    public HiveHdfsConfiguration(HdfsConfigurationUpdater updater) {
        this.updater = Objects.requireNonNull(updater, "updater is null");
    }

    @Override
    public Configuration getConfiguration(HdfsEnvironment.HdfsContext context, URI uri) {
        return this.hadoopConfiguration.get();
    }

    static {
        Configuration.addDefaultResource("hdfs-default.xml");
        Configuration.addDefaultResource("hdfs-site.xml");
        INITIAL_CONFIGURATION = new Configuration(false);
        Configuration defaultConfiguration = new Configuration();
        ConfigurationUtils.copy(defaultConfiguration, INITIAL_CONFIGURATION);
    }
}

