/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ServiceLoader;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.HadoopKerberosName;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.SecurityInfo;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenInfo;
import sun.net.dns.ResolverConfiguration;
import sun.net.util.IPAddressUtil;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class SecurityUtil {
    public static final Log LOG = LogFactory.getLog(SecurityUtil.class);
    public static final String HOSTNAME_PATTERN = "_HOST";
    @VisibleForTesting
    static boolean useIpForTokenService;
    @VisibleForTesting
    static HostResolver hostResolver;
    private static ServiceLoader<SecurityInfo> securityInfoProviders;
    private static SecurityInfo[] testProviders;

    @InterfaceAudience.Private
    static void setTokenServiceUseIp(boolean flag) {
        useIpForTokenService = flag;
        hostResolver = !useIpForTokenService ? new QualifiedHostResolver() : new StandardHostResolver();
    }

    static boolean isTGSPrincipal(KerberosPrincipal principal) {
        if (principal == null) {
            return false;
        }
        return principal.getName().equals("krbtgt/" + principal.getRealm() + "@" + principal.getRealm());
    }

    protected static boolean isOriginalTGT(KerberosTicket ticket) {
        return SecurityUtil.isTGSPrincipal(ticket.getServer());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static String getServerPrincipal(String principalConfig, String hostname) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        return SecurityUtil.replacePattern(components, hostname);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static String getServerPrincipal(String principalConfig, InetAddress addr) throws IOException {
        String[] components = SecurityUtil.getComponents(principalConfig);
        if (components == null || components.length != 3 || !components[1].equals(HOSTNAME_PATTERN)) {
            return principalConfig;
        }
        if (addr == null) {
            throw new IOException("Can't replace _HOST pattern since client address is null");
        }
        return SecurityUtil.replacePattern(components, addr.getCanonicalHostName());
    }

    private static String[] getComponents(String principalConfig) {
        if (principalConfig == null) {
            return null;
        }
        return principalConfig.split("[/@]");
    }

    private static String replacePattern(String[] components, String hostname) throws IOException {
        String fqdn = hostname;
        if (fqdn == null || fqdn.isEmpty() || fqdn.equals("0.0.0.0")) {
            fqdn = SecurityUtil.getLocalHostName();
        }
        return components[0] + "/" + fqdn.toLowerCase(Locale.US) + "@" + components[2];
    }

    static String getLocalHostName() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void login(Configuration conf, String keytabFileKey, String userNameKey) throws IOException {
        SecurityUtil.login(conf, keytabFileKey, userNameKey, SecurityUtil.getLocalHostName());
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static void login(Configuration conf, String keytabFileKey, String userNameKey, String hostname) throws IOException {
        if (!UserGroupInformation.isSecurityEnabled()) {
            return;
        }
        String keytabFilename = conf.get(keytabFileKey);
        if (keytabFilename == null || keytabFilename.length() == 0) {
            throw new IOException("Running in secure mode, but config doesn't have a keytab");
        }
        String principalConfig = conf.get(userNameKey, System.getProperty("user.name"));
        String principalName = SecurityUtil.getServerPrincipal(principalConfig, hostname);
        UserGroupInformation.loginUserFromKeytab(principalName, keytabFilename);
    }

    public static String buildDTServiceName(URI uri, int defPort) {
        String authority = uri.getAuthority();
        if (authority == null) {
            return null;
        }
        InetSocketAddress addr = NetUtils.createSocketAddr(authority, defPort);
        return SecurityUtil.buildTokenService(addr).toString();
    }

    public static String getHostFromPrincipal(String principalName) {
        return new HadoopKerberosName(principalName).getHostName();
    }

    @InterfaceAudience.Private
    public static void setSecurityInfoProviders(SecurityInfo ... providers) {
        testProviders = providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KerberosInfo getKerberosInfo(Class<?> protocol, Configuration conf) {
        Object object = testProviders;
        synchronized (testProviders) {
            for (SecurityInfo provider : testProviders) {
                KerberosInfo result = provider.getKerberosInfo(protocol, conf);
                if (result == null) continue;
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
            object = securityInfoProviders;
            synchronized (object) {
                for (SecurityInfo provider : securityInfoProviders) {
                    KerberosInfo result = provider.getKerberosInfo(protocol, conf);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TokenInfo getTokenInfo(Class<?> protocol, Configuration conf) {
        Object object = testProviders;
        synchronized (testProviders) {
            for (SecurityInfo provider : testProviders) {
                TokenInfo result = provider.getTokenInfo(protocol, conf);
                if (result == null) continue;
                // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
                return result;
            }
            // ** MonitorExit[var2_2 /* !! */ ] (shouldn't be in output)
            object = securityInfoProviders;
            synchronized (object) {
                for (SecurityInfo provider : securityInfoProviders) {
                    TokenInfo result = provider.getTokenInfo(protocol, conf);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
    }

    public static InetSocketAddress getTokenServiceAddr(Token<?> token) {
        return NetUtils.createSocketAddr(token.getService().toString());
    }

    public static void setTokenService(Token<?> token, InetSocketAddress addr) {
        Text service = SecurityUtil.buildTokenService(addr);
        if (token != null) {
            token.setService(service);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Acquired token " + token);
            }
        } else {
            LOG.warn("Failed to get token for service " + service);
        }
    }

    public static Text buildTokenService(InetSocketAddress addr) {
        String host = null;
        if (useIpForTokenService) {
            if (addr.isUnresolved()) {
                throw new IllegalArgumentException(new UnknownHostException(addr.getHostName()));
            }
            host = addr.getAddress().getHostAddress();
        } else {
            host = addr.getHostName().toLowerCase();
        }
        return new Text(host + ":" + addr.getPort());
    }

    public static Text buildTokenService(URI uri) {
        return SecurityUtil.buildTokenService(NetUtils.createSocketAddr(uri.getAuthority()));
    }

    public static <T> T doAsLoginUserOrFatal(PrivilegedAction<T> action) {
        if (UserGroupInformation.isSecurityEnabled()) {
            UserGroupInformation ugi = null;
            try {
                ugi = UserGroupInformation.getLoginUser();
            }
            catch (IOException e) {
                LOG.fatal("Exception while getting login user", e);
                e.printStackTrace();
                Runtime.getRuntime().exit(-1);
            }
            return ugi.doAs(action);
        }
        return action.run();
    }

    public static <T> T doAsLoginUser(PrivilegedExceptionAction<T> action) throws IOException {
        return SecurityUtil.doAsUser(UserGroupInformation.getLoginUser(), action);
    }

    public static <T> T doAsCurrentUser(PrivilegedExceptionAction<T> action) throws IOException {
        return SecurityUtil.doAsUser(UserGroupInformation.getCurrentUser(), action);
    }

    private static <T> T doAsUser(UserGroupInformation ugi, PrivilegedExceptionAction<T> action) throws IOException {
        try {
            return ugi.doAs(action);
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    @InterfaceAudience.Private
    public static InetAddress getByName(String hostname) throws UnknownHostException {
        return hostResolver.getByName(hostname);
    }

    public static UserGroupInformation.AuthenticationMethod getAuthenticationMethod(Configuration conf) {
        String value = conf.get("hadoop.security.authentication", "simple");
        try {
            return Enum.valueOf(UserGroupInformation.AuthenticationMethod.class, value.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException("Invalid attribute value for hadoop.security.authentication of " + value);
        }
    }

    public static void setAuthenticationMethod(UserGroupInformation.AuthenticationMethod authenticationMethod, Configuration conf) {
        if (authenticationMethod == null) {
            authenticationMethod = UserGroupInformation.AuthenticationMethod.SIMPLE;
        }
        conf.set("hadoop.security.authentication", authenticationMethod.toString().toLowerCase(Locale.ENGLISH));
    }

    static {
        Configuration conf = new Configuration();
        boolean useIp = conf.getBoolean("hadoop.security.token.service.use_ip", true);
        SecurityUtil.setTokenServiceUseIp(useIp);
        securityInfoProviders = ServiceLoader.load(SecurityInfo.class);
        testProviders = new SecurityInfo[0];
    }

    protected static class QualifiedHostResolver
    implements HostResolver {
        private List<String> searchDomains = ResolverConfiguration.open().searchlist();

        protected QualifiedHostResolver() {
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            InetAddress addr = null;
            if (IPAddressUtil.isIPv4LiteralAddress(host)) {
                byte[] ip = IPAddressUtil.textToNumericFormatV4(host);
                addr = InetAddress.getByAddress(host, ip);
            } else if (IPAddressUtil.isIPv6LiteralAddress(host)) {
                byte[] ip = IPAddressUtil.textToNumericFormatV6(host);
                addr = InetAddress.getByAddress(host, ip);
            } else if (host.endsWith(".")) {
                addr = this.getByExactName(host);
            } else if (host.contains(".")) {
                addr = this.getByExactName(host);
                if (addr == null) {
                    addr = this.getByNameWithSearch(host);
                }
            } else {
                InetAddress loopback = InetAddress.getByName(null);
                if (host.equalsIgnoreCase(loopback.getHostName())) {
                    addr = InetAddress.getByAddress(host, loopback.getAddress());
                } else {
                    addr = this.getByNameWithSearch(host);
                    if (addr == null) {
                        addr = this.getByExactName(host);
                    }
                }
            }
            if (addr == null) {
                throw new UnknownHostException(host);
            }
            return addr;
        }

        InetAddress getByExactName(String host) {
            InetAddress addr = null;
            String fqHost = host;
            if (!fqHost.endsWith(".")) {
                fqHost = fqHost + ".";
            }
            try {
                addr = this.getInetAddressByName(fqHost);
                addr = InetAddress.getByAddress(host, addr.getAddress());
            }
            catch (UnknownHostException e) {
                // empty catch block
            }
            return addr;
        }

        InetAddress getByNameWithSearch(String host) {
            InetAddress addr = null;
            if (host.endsWith(".")) {
                addr = this.getByExactName(host);
            } else {
                for (String domain : this.searchDomains) {
                    String dot;
                    String string = dot = !domain.startsWith(".") ? "." : "";
                    addr = this.getByExactName(host + dot + domain);
                    if (addr == null) continue;
                    break;
                }
            }
            return addr;
        }

        InetAddress getInetAddressByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }

        void setSearchDomains(String ... domains) {
            this.searchDomains = Arrays.asList(domains);
        }
    }

    static class StandardHostResolver
    implements HostResolver {
        StandardHostResolver() {
        }

        @Override
        public InetAddress getByName(String host) throws UnknownHostException {
            return InetAddress.getByName(host);
        }
    }

    static interface HostResolver {
        public InetAddress getByName(String var1) throws UnknownHostException;
    }
}

