/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.utils;

import java.io.File;
import java.io.IOException;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.fs.s3.common.utils.RefCountedFSOutputStream;
import org.apache.flink.fs.s3.common.utils.RefCountedFileWithStream;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

@Internal
public class RefCountedBufferingFileStream
extends RefCountedFSOutputStream {
    public static final int BUFFER_SIZE = 4096;
    private final RefCountedFileWithStream currentTmpFile;
    private final byte[] buffer;
    private int positionInBuffer;
    private boolean closed;

    @VisibleForTesting
    public RefCountedBufferingFileStream(RefCountedFileWithStream file, int bufferSize) {
        Preconditions.checkArgument(((long)bufferSize > 0L ? 1 : 0) != 0);
        this.currentTmpFile = (RefCountedFileWithStream)((Object)Preconditions.checkNotNull((Object)((Object)file)));
        this.buffer = new byte[bufferSize];
        this.positionInBuffer = 0;
        this.closed = false;
    }

    @Override
    public File getInputFile() {
        return this.currentTmpFile.getFile();
    }

    public long getPos() {
        return this.currentTmpFile.getLength() + (long)this.positionInBuffer;
    }

    public void write(int b) throws IOException {
        if (this.positionInBuffer >= this.buffer.length) {
            this.flush();
        }
        this.requireOpen();
        this.buffer[this.positionInBuffer++] = (byte)b;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buffer.length) {
            this.flush();
            this.currentTmpFile.write(b, off, len);
            return;
        }
        this.requireOpen();
        if (len > this.buffer.length - this.positionInBuffer) {
            this.flush();
        }
        System.arraycopy(b, off, this.buffer, this.positionInBuffer, len);
        this.positionInBuffer += len;
    }

    public void flush() throws IOException {
        this.currentTmpFile.write(this.buffer, 0, this.positionInBuffer);
        this.currentTmpFile.flush();
        this.positionInBuffer = 0;
    }

    public void sync() throws IOException {
        throw new UnsupportedOperationException("S3RecoverableFsDataOutputStream cannot sync state to S3. Use persist() to create a persistent recoverable intermediate point.");
    }

    @Override
    public boolean isClosed() throws IOException {
        return this.closed;
    }

    public void close() {
        if (!this.closed) {
            this.currentTmpFile.closeStream();
            this.closed = true;
        }
    }

    public void retain() {
        this.currentTmpFile.retain();
    }

    public boolean release() {
        return this.currentTmpFile.release();
    }

    private void requireOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
    }

    public String toString() {
        return "Reference Counted File with {path='" + this.currentTmpFile.getFile().toPath().toAbsolutePath() + "', size=" + this.getPos() + ", reference counter=" + this.currentTmpFile.getReferenceCounter() + ", closed=" + this.closed + '}';
    }

    @VisibleForTesting
    int getPositionInBuffer() {
        return this.positionInBuffer;
    }

    @VisibleForTesting
    public int getReferenceCounter() {
        return this.currentTmpFile.getReferenceCounter();
    }

    public static RefCountedBufferingFileStream openNew(FunctionWithException<File, RefCountedFileWithStream, IOException> tmpFileProvider) throws IOException {
        return new RefCountedBufferingFileStream((RefCountedFileWithStream)((Object)tmpFileProvider.apply(null)), 4096);
    }

    public static RefCountedBufferingFileStream restore(FunctionWithException<File, RefCountedFileWithStream, IOException> tmpFileProvider, File initialTmpFile) throws IOException {
        return new RefCountedBufferingFileStream((RefCountedFileWithStream)((Object)tmpFileProvider.apply((Object)initialTmpFile)), 4096);
    }
}

