/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveFileWriter;
import com.facebook.presto.orc.OrcDataSource;
import com.facebook.presto.orc.OrcWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockBuilderStatus;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SliceOutput;
import io.airlift.units.DataSize;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.joda.time.DateTimeZone;

public class OrcFileWriter
implements HiveFileWriter {
    private final OrcWriter orcWriter;
    private final Callable<Void> rollbackAction;
    private final int[] fileInputColumnIndexes;
    private final List<Block> nullBlocks;
    private final Optional<Supplier<OrcDataSource>> validationInputFactory;

    public OrcFileWriter(OutputStream outputStream, Callable<Void> rollbackAction, boolean isDwrf, List<String> columnNames, List<Type> fileColumnTypes, CompressionKind compression, int[] fileInputColumnIndexes, Map<String, String> metadata, DateTimeZone hiveStorageTimeZone, Optional<Supplier<OrcDataSource>> validationInputFactory) {
        if (!(outputStream instanceof SliceOutput)) {
            outputStream = new OutputStreamSliceOutput(outputStream);
        }
        this.orcWriter = isDwrf ? OrcWriter.createDwrfWriter((SliceOutput)((SliceOutput)outputStream), columnNames, fileColumnTypes, (CompressionKind)compression, (DataSize)OrcWriter.DEFAULT_STRIPE_MAX_SIZE, (int)100000, (int)10000000, (int)10000, (DataSize)OrcWriter.DEFAULT_DICTIONARY_MEMORY_MAX_SIZE, metadata, (DateTimeZone)hiveStorageTimeZone, (boolean)validationInputFactory.isPresent()) : OrcWriter.createOrcWriter((SliceOutput)((SliceOutput)outputStream), columnNames, fileColumnTypes, (CompressionKind)compression, (DataSize)OrcWriter.DEFAULT_STRIPE_MAX_SIZE, (int)100000, (int)10000000, (int)10000, (DataSize)OrcWriter.DEFAULT_DICTIONARY_MEMORY_MAX_SIZE, metadata, (DateTimeZone)hiveStorageTimeZone, (boolean)validationInputFactory.isPresent());
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
        this.fileInputColumnIndexes = Objects.requireNonNull(fileInputColumnIndexes, "outputColumnInputIndexes is null");
        ImmutableList.Builder nullBlocks = ImmutableList.builder();
        for (Type fileColumnType : fileColumnTypes) {
            BlockBuilder blockBuilder = fileColumnType.createBlockBuilder(new BlockBuilderStatus(), 1, 0);
            blockBuilder.appendNull();
            nullBlocks.add(blockBuilder.build());
        }
        this.nullBlocks = nullBlocks.build();
        this.validationInputFactory = validationInputFactory;
    }

    @Override
    public long getSystemMemoryUsage() {
        return this.orcWriter.getRetainedBytes();
    }

    @Override
    public void appendRows(Page dataPage) {
        Block[] blocks = new Block[this.fileInputColumnIndexes.length];
        for (int i = 0; i < this.fileInputColumnIndexes.length; ++i) {
            int inputColumnIndex = this.fileInputColumnIndexes[i];
            blocks[i] = inputColumnIndex < 0 ? new RunLengthEncodedBlock(this.nullBlocks.get(i), dataPage.getPositionCount()) : dataPage.getBlock(inputColumnIndex);
        }
        Page page = new Page(dataPage.getPositionCount(), blocks);
        try {
            this.orcWriter.write(page);
        }
        catch (IOException | UncheckedIOException e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    @Override
    public void commit() {
        try {
            this.orcWriter.close();
        }
        catch (IOException | UncheckedIOException e) {
            try {
                this.rollbackAction.call();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
        if (this.validationInputFactory.isPresent()) {
            try (OrcDataSource input = this.validationInputFactory.get().get();){
                this.orcWriter.validate(input);
            }
            catch (IOException | UncheckedIOException e) {
                throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITE_VALIDATION_FAILED, (Throwable)e);
            }
        }
    }

    @Override
    public void rollback() {
        try {
            try {
                this.orcWriter.close();
            }
            finally {
                this.rollbackAction.call();
            }
        }
        catch (Exception e) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("writer", this.orcWriter).toString();
    }
}

