/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Tristate;
import org.apache.hadoop.fs.s3a.s3guard.PathMetadata;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DirListingMetadata {
    public static final Collection<PathMetadata> EMPTY_DIR = Collections.emptyList();
    private final Path path;
    private Map<Path, PathMetadata> listMap = new ConcurrentHashMap<Path, PathMetadata>();
    private boolean isAuthoritative;

    public DirListingMetadata(Path path, Collection<PathMetadata> listing, boolean isAuthoritative) {
        this.checkPathAbsolute(path);
        this.path = path;
        if (listing != null) {
            for (PathMetadata entry : listing) {
                Path childPath = entry.getFileStatus().getPath();
                this.checkChildPath(childPath);
                this.listMap.put(childPath, entry);
            }
        }
        this.isAuthoritative = isAuthoritative;
    }

    public DirListingMetadata(DirListingMetadata d) {
        this.path = d.path;
        this.isAuthoritative = d.isAuthoritative;
        this.listMap = new ConcurrentHashMap<Path, PathMetadata>(d.listMap);
    }

    public Path getPath() {
        return this.path;
    }

    public Collection<PathMetadata> getListing() {
        return Collections.unmodifiableCollection(this.listMap.values());
    }

    public Set<Path> listTombstones() {
        HashSet<Path> tombstones = new HashSet<Path>();
        for (PathMetadata meta : this.listMap.values()) {
            if (!meta.isDeleted()) continue;
            tombstones.add(meta.getFileStatus().getPath());
        }
        return tombstones;
    }

    public DirListingMetadata withoutTombstones() {
        ArrayList<PathMetadata> filteredList = new ArrayList<PathMetadata>();
        for (PathMetadata meta : this.listMap.values()) {
            if (meta.isDeleted()) continue;
            filteredList.add(meta);
        }
        return new DirListingMetadata(this.path, filteredList, this.isAuthoritative);
    }

    public int numEntries() {
        return this.listMap.size();
    }

    public boolean isAuthoritative() {
        return this.isAuthoritative;
    }

    public Tristate isEmpty() {
        if (this.getListing().isEmpty()) {
            if (this.isAuthoritative()) {
                return Tristate.TRUE;
            }
            return Tristate.UNKNOWN;
        }
        return Tristate.FALSE;
    }

    public void setAuthoritative(boolean authoritative) {
        this.isAuthoritative = authoritative;
    }

    public PathMetadata get(Path childPath) {
        this.checkChildPath(childPath);
        return this.listMap.get(childPath);
    }

    public void markDeleted(Path childPath) {
        this.checkChildPath(childPath);
        this.listMap.put(childPath, PathMetadata.tombstone(childPath));
    }

    public void remove(Path childPath) {
        this.checkChildPath(childPath);
        this.listMap.remove(childPath);
    }

    public boolean put(FileStatus childFileStatus) {
        Preconditions.checkNotNull(childFileStatus, "childFileStatus must be non-null");
        Path childPath = this.childStatusToPathKey(childFileStatus);
        PathMetadata newValue = new PathMetadata(childFileStatus);
        PathMetadata oldValue = this.listMap.put(childPath, newValue);
        return oldValue == null || !oldValue.equals(newValue);
    }

    public String toString() {
        return "DirListingMetadata{path=" + this.path + ", listMap=" + this.listMap + ", isAuthoritative=" + this.isAuthoritative + '}';
    }

    public void prettyPrint(StringBuilder sb) {
        sb.append(String.format("DirMeta %-20s %-18s", this.path.toString(), this.isAuthoritative ? "Authoritative" : "Not Authoritative"));
        for (Map.Entry<Path, PathMetadata> entry : this.listMap.entrySet()) {
            sb.append("\n   key: ").append(entry.getKey()).append(": ");
            entry.getValue().prettyPrint(sb);
        }
        sb.append("\n");
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        this.prettyPrint(sb);
        return sb.toString();
    }

    private void checkChildPath(Path childPath) {
        this.checkPathAbsolute(childPath);
        URI parentUri = this.path.toUri();
        if (parentUri.getHost() != null) {
            URI childUri = childPath.toUri();
            Preconditions.checkNotNull(childUri.getHost(), "Expected non-null URI host: %s", new Object[]{childUri});
            Preconditions.checkArgument(childUri.getHost().equals(parentUri.getHost()), "childUri %s and parentUri %s must have the same host", new Object[]{childUri, parentUri});
            Preconditions.checkNotNull(childUri.getScheme(), "No scheme in path %s", new Object[]{childUri});
        }
        Preconditions.checkArgument(!childPath.isRoot(), "childPath cannot be the root path: %s", new Object[]{childPath});
        Preconditions.checkArgument(childPath.getParent().equals(this.path), "childPath %s must be a child of %s", new Object[]{childPath, this.path});
    }

    private Path childStatusToPathKey(FileStatus status) {
        Path p = status.getPath();
        Preconditions.checkNotNull(p, "Child status' path cannot be null");
        Preconditions.checkArgument(!p.isRoot(), "childPath cannot be the root path: %s", new Object[]{p});
        Preconditions.checkArgument(p.getParent().equals(this.path), "childPath %s must be a child of %s", new Object[]{p, this.path});
        URI uri = p.toUri();
        URI parentUri = this.path.toUri();
        if (uri.getHost() == null && parentUri.getHost() != null) {
            try {
                return new Path(new URI(parentUri.getScheme(), parentUri.getHost(), uri.getPath(), uri.getFragment()));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("FileStatus path invalid with added " + parentUri.getScheme() + "://" + parentUri.getHost() + " added", e);
            }
        }
        return p;
    }

    private void checkPathAbsolute(Path p) {
        Preconditions.checkNotNull(p, "path must be non-null");
        Preconditions.checkArgument(p.isAbsolute(), "path must be absolute: %s", new Object[]{p});
    }
}

