/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.fs.s3.common.utils.RefCountedFile;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;

@Internal
public class RefCountedTmpFileCreator
implements FunctionWithException<File, RefCountedFile, IOException> {
    private final File[] tempDirectories;
    private final AtomicInteger next;

    private RefCountedTmpFileCreator(File ... tempDirectories) {
        Preconditions.checkArgument((tempDirectories.length > 0 ? 1 : 0) != 0, (Object)"tempDirectories must not be empty");
        for (File f : tempDirectories) {
            if (f != null) continue;
            throw new IllegalArgumentException("tempDirectories contains null entries");
        }
        this.tempDirectories = (File[])tempDirectories.clone();
        this.next = new AtomicInteger(new Random().nextInt(this.tempDirectories.length));
    }

    public RefCountedFile apply(File file) throws IOException {
        File directory = this.tempDirectories[this.nextIndex()];
        while (true) {
            try {
                if (file == null) {
                    File newFile = new File(directory, ".tmp_" + UUID.randomUUID());
                    OutputStream out = Files.newOutputStream(newFile.toPath(), StandardOpenOption.CREATE_NEW);
                    return RefCountedFile.newFile(newFile, out);
                }
                OutputStream out = Files.newOutputStream(file.toPath(), StandardOpenOption.APPEND);
                return RefCountedFile.restoredFile(file, out, file.length());
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                continue;
            }
            break;
        }
    }

    private int nextIndex() {
        int newIndex;
        int currIndex;
        do {
            if ((newIndex = (currIndex = this.next.get()) + 1) != this.tempDirectories.length) continue;
            newIndex = 0;
        } while (!this.next.compareAndSet(currIndex, newIndex));
        return currIndex;
    }

    public static RefCountedTmpFileCreator inDirectories(File ... tmpDirectories) {
        return new RefCountedTmpFileCreator(tmpDirectories);
    }
}

