/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.fs.s3.common.utils.OffsetAwareOutputStream;
import org.apache.flink.fs.s3.common.utils.RefCounted;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.Preconditions;

@Internal
public class RefCountedFile
implements RefCounted {
    private final File file;
    private final OffsetAwareOutputStream stream;
    private final AtomicInteger references;
    private boolean closed;

    private RefCountedFile(File file, OutputStream currentOut, long bytesInCurrentPart) {
        this.file = (File)Preconditions.checkNotNull((Object)file);
        this.references = new AtomicInteger(1);
        this.stream = new OffsetAwareOutputStream(currentOut, bytesInCurrentPart);
        this.closed = false;
    }

    public File getFile() {
        return this.file;
    }

    public OffsetAwareOutputStream getStream() {
        return this.stream;
    }

    public long getLength() {
        return this.stream.getLength();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.requireOpened();
        if (len > 0) {
            this.stream.write(b, off, len);
        }
    }

    public void flush() throws IOException {
        this.requireOpened();
        this.stream.flush();
    }

    public void closeStream() {
        if (!this.closed) {
            IOUtils.closeQuietly((AutoCloseable)this.stream);
            this.closed = true;
        }
    }

    @Override
    public void retain() {
        this.references.incrementAndGet();
    }

    @Override
    public boolean release() {
        if (this.references.decrementAndGet() == 0) {
            return this.tryClose();
        }
        return false;
    }

    private boolean tryClose() {
        try {
            Files.deleteIfExists(this.file.toPath());
            return true;
        }
        catch (Throwable t) {
            ExceptionUtils.rethrowIfFatalError((Throwable)t);
            return false;
        }
    }

    private void requireOpened() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed.");
        }
    }

    @VisibleForTesting
    int getReferenceCounter() {
        return this.references.get();
    }

    public static RefCountedFile newFile(File file, OutputStream currentOut) throws IOException {
        return new RefCountedFile(file, currentOut, 0L);
    }

    public static RefCountedFile restoredFile(File file, OutputStream currentOut, long bytesInCurrentPart) {
        return new RefCountedFile(file, currentOut, bytesInCurrentPart);
    }
}

