/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Nullable;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.FileSystemFactory;
import org.apache.flink.fs.s3.common.FlinkS3FileSystem;
import org.apache.flink.fs.s3.common.writer.S3AccessHelper;
import org.apache.flink.fs.s3presto.common.HadoopConfigLoader;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractS3FileSystemFactory
implements FileSystemFactory {
    public static final ConfigOption<Long> PART_UPLOAD_MIN_SIZE = ConfigOptions.key((String)"s3.upload.min.part.size").defaultValue((Object)0x500000L).withDescription("This option is relevant to the Recoverable Writer and sets the min size of data that buffered locally, before being sent to S3. Flink also takes care of checkpointing locally buffered data. This value cannot be less than 5MB or greater than 5GB (limits set by Amazon).");
    public static final ConfigOption<Integer> MAX_CONCURRENT_UPLOADS = ConfigOptions.key((String)"s3.upload.max.concurrent.uploads").defaultValue((Object)Runtime.getRuntime().availableProcessors()).withDescription("This option is relevant to the Recoverable Writer and limits the number of parts that can be concurrently in-flight. By default, this is set to " + Runtime.getRuntime().availableProcessors() + ".");
    public static final ConfigOption<String> ENTROPY_INJECT_KEY_OPTION = ConfigOptions.key((String)"s3.entropy.key").noDefaultValue().withDescription("This option can be used to improve performance due to sharding issues on Amazon S3. For file creations with entropy injection, this key will be replaced by random alphanumeric characters. For other file creations, the key will be filtered out.");
    public static final ConfigOption<Integer> ENTROPY_INJECT_LENGTH_OPTION = ConfigOptions.key((String)"s3.entropy.length").defaultValue((Object)4).withDescription("When '" + ENTROPY_INJECT_KEY_OPTION.key() + "' is set, this option defines the number of random characters to replace the entropy key with.");
    private static final String INVALID_ENTROPY_KEY_CHARS = "^.*[~#@*+%{}<>\\[\\]|\"\\\\].*$";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractS3FileSystemFactory.class);
    private final String name;
    private final HadoopConfigLoader hadoopConfigLoader;
    private Configuration flinkConfig;

    protected AbstractS3FileSystemFactory(String name, HadoopConfigLoader hadoopConfigLoader) {
        this.name = name;
        this.hadoopConfigLoader = hadoopConfigLoader;
    }

    public void configure(Configuration config) {
        this.flinkConfig = config;
        this.hadoopConfigLoader.setFlinkConfig(config);
    }

    public FileSystem create(URI fsUri) throws IOException {
        Configuration flinkConfig = this.flinkConfig;
        if (flinkConfig == null) {
            LOG.warn("Creating S3 FileSystem without configuring the factory. All behavior will be default.");
            flinkConfig = new Configuration();
        }
        LOG.debug("Creating S3 file system backed by {}", (Object)this.name);
        LOG.debug("Loading Hadoop configuration for {}", (Object)this.name);
        try {
            String[] localTmpDirectories;
            org.apache.hadoop.conf.Configuration hadoopConfig = this.hadoopConfigLoader.getOrLoadHadoopConfig();
            org.apache.hadoop.fs.FileSystem fs = this.createHadoopFileSystem();
            fs.initialize(this.getInitURI(fsUri, hadoopConfig), hadoopConfig);
            String entropyInjectionKey = flinkConfig.getString(ENTROPY_INJECT_KEY_OPTION);
            int numEntropyChars = -1;
            if (entropyInjectionKey != null) {
                if (entropyInjectionKey.matches(INVALID_ENTROPY_KEY_CHARS)) {
                    throw new IllegalConfigurationException("Invalid character in value for " + ENTROPY_INJECT_KEY_OPTION.key() + " : " + entropyInjectionKey);
                }
                numEntropyChars = flinkConfig.getInteger(ENTROPY_INJECT_LENGTH_OPTION);
                if (numEntropyChars <= 0) {
                    throw new IllegalConfigurationException(ENTROPY_INJECT_LENGTH_OPTION.key() + " must configure a value > 0");
                }
            }
            Preconditions.checkArgument(((localTmpDirectories = ConfigurationUtils.parseTempDirectories((Configuration)flinkConfig)).length > 0 ? 1 : 0) != 0);
            String localTmpDirectory = localTmpDirectories[0];
            long s3minPartSize = flinkConfig.getLong(PART_UPLOAD_MIN_SIZE);
            int maxConcurrentUploads = flinkConfig.getInteger(MAX_CONCURRENT_UPLOADS);
            S3AccessHelper s3AccessHelper = this.getS3AccessHelper(fs);
            return new FlinkS3FileSystem(fs, localTmpDirectory, entropyInjectionKey, numEntropyChars, s3AccessHelper, s3minPartSize, maxConcurrentUploads);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    protected abstract org.apache.hadoop.fs.FileSystem createHadoopFileSystem();

    protected abstract URI getInitURI(URI var1, org.apache.hadoop.conf.Configuration var2);

    @Nullable
    protected abstract S3AccessHelper getS3AccessHelper(org.apache.hadoop.fs.FileSystem var1);
}

