/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats.cardinality;

import com.google.common.base.Preconditions;

final class Utils {
    private Utils() {
    }

    public static double alpha(int indexBitLength) {
        switch (indexBitLength) {
            case 4: {
                return 0.673;
            }
            case 5: {
                return 0.697;
            }
            case 6: {
                return 0.709;
            }
        }
        return 0.7213 / (1.0 + 1.079 / (double)Utils.numberOfBuckets(indexBitLength));
    }

    public static boolean isPowerOf2(long value) {
        Preconditions.checkArgument(value > 0L, "value must be positive");
        return (value & value - 1L) == 0L;
    }

    public static int indexBitLength(int numberOfBuckets) {
        Preconditions.checkArgument(Utils.isPowerOf2(numberOfBuckets), "numberOfBuckets must be a power of 2, actual: %s", numberOfBuckets);
        return (int)(Math.log(numberOfBuckets) / Math.log(2.0));
    }

    public static int numberOfBuckets(int indexBitLength) {
        return 1 << indexBitLength;
    }

    public static int computeIndex(long hash, int indexBitLength) {
        return (int)(hash >>> 64 - indexBitLength);
    }

    public static int numberOfLeadingZeros(long hash, int indexBitLength) {
        long value = hash << indexBitLength | 1L << indexBitLength - 1;
        return Long.numberOfLeadingZeros(value);
    }

    public static int computeValue(long hash, int indexBitLength) {
        return Utils.numberOfLeadingZeros(hash, indexBitLength) + 1;
    }

    public static double linearCounting(int zeroBuckets, int totalBuckets) {
        return (double)totalBuckets * Math.log((double)totalBuckets * 1.0 / (double)zeroBuckets);
    }
}

