/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.security;

import com.facebook.presto.hive.security.LegacySecurityModule;
import com.facebook.presto.hive.security.SecurityConfig;
import com.facebook.presto.hive.security.SqlStandardSecurityModule;
import com.facebook.presto.plugin.base.security.FileBasedAccessControlModule;
import com.facebook.presto.plugin.base.security.ReadOnlySecurityModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;

public class HiveSecurityModule
extends AbstractConfigurationAwareModule {
    @Override
    protected void setup(Binder binder) {
        this.bindSecurityModule("legacy", new LegacySecurityModule());
        this.bindSecurityModule("file", (Module)new FileBasedAccessControlModule());
        this.bindSecurityModule("read-only", (Module)new ReadOnlySecurityModule());
        this.bindSecurityModule("sql-standard", new SqlStandardSecurityModule());
    }

    private void bindSecurityModule(String name, Module module) {
        this.install(ConditionalModule.installModuleIf(SecurityConfig.class, security -> name.equalsIgnoreCase(security.getSecuritySystem()), module));
    }
}

