/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet;

import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.hive.parquet.ParquetEncoding;
import com.facebook.presto.hive.parquet.RichColumnDescriptor;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import parquet.column.ColumnDescriptor;
import parquet.column.Encoding;
import parquet.io.ColumnIO;
import parquet.io.ColumnIOFactory;
import parquet.io.InvalidRecordException;
import parquet.io.ParquetDecodingException;
import parquet.io.PrimitiveColumnIO;
import parquet.schema.DecimalMetadata;
import parquet.schema.MessageType;
import parquet.schema.OriginalType;
import parquet.schema.Type;

public final class ParquetTypeUtils {
    private ParquetTypeUtils() {
    }

    public static List<PrimitiveColumnIO> getColumns(MessageType fileSchema, MessageType requestedSchema) {
        return new ColumnIOFactory().getColumnIO(requestedSchema, fileSchema, true).getLeaves();
    }

    public static Optional<RichColumnDescriptor> getDescriptor(MessageType fileSchema, MessageType requestedSchema, List<String> path) {
        Preconditions.checkArgument(path.size() >= 1, "Parquet nested path should have at least one component");
        int index = ParquetTypeUtils.getPathIndex(fileSchema, requestedSchema, path);
        return ParquetTypeUtils.getDescriptor(fileSchema, requestedSchema, index);
    }

    public static Optional<RichColumnDescriptor> getDescriptor(MessageType fileSchema, MessageType requestedSchema, int index) {
        if (index == -1) {
            return Optional.empty();
        }
        PrimitiveColumnIO columnIO = ParquetTypeUtils.getColumns(fileSchema, requestedSchema).get(index);
        ColumnDescriptor descriptor = columnIO.getColumnDescriptor();
        return Optional.of(new RichColumnDescriptor(descriptor.getPath(), columnIO.getType().asPrimitiveType(), descriptor.getMaxRepetitionLevel(), descriptor.getMaxDefinitionLevel()));
    }

    private static int getPathIndex(MessageType fileSchema, MessageType requestedSchema, List<String> path) {
        int maxLevel = path.size();
        List<PrimitiveColumnIO> columns = ParquetTypeUtils.getColumns(fileSchema, requestedSchema);
        int index = -1;
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            ColumnIO[] fields = columns.get(columnIndex).getPath();
            if (fields.length <= maxLevel || !fields[maxLevel].getName().equalsIgnoreCase(path.get(maxLevel - 1))) continue;
            boolean match = true;
            for (int level = 0; level < maxLevel - 1; ++level) {
                if (fields[level + 1].getName().equalsIgnoreCase(path.get(level))) continue;
                match = false;
            }
            if (!match) continue;
            index = columnIndex;
        }
        return index;
    }

    public static com.facebook.presto.spi.type.Type getPrestoType(RichColumnDescriptor descriptor) {
        switch (descriptor.getType()) {
            case BOOLEAN: {
                return BooleanType.BOOLEAN;
            }
            case BINARY: {
                return ParquetTypeUtils.createDecimalType(descriptor).orElse((com.facebook.presto.spi.type.Type)VarcharType.VARCHAR);
            }
            case FLOAT: {
                return RealType.REAL;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case INT32: {
                return ParquetTypeUtils.createDecimalType(descriptor).orElse((com.facebook.presto.spi.type.Type)IntegerType.INTEGER);
            }
            case INT64: {
                return ParquetTypeUtils.createDecimalType(descriptor).orElse((com.facebook.presto.spi.type.Type)BigintType.BIGINT);
            }
            case INT96: {
                return TimestampType.TIMESTAMP;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return ParquetTypeUtils.createDecimalType(descriptor).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Parquet type FIXED_LEN_BYTE_ARRAY supported as DECIMAL; got " + descriptor.getPrimitiveType().getOriginalType()));
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported parquet type: " + descriptor.getType());
    }

    public static int getFieldIndex(MessageType fileSchema, String name) {
        try {
            return fileSchema.getFieldIndex(name);
        }
        catch (InvalidRecordException e) {
            for (Type type : fileSchema.getFields()) {
                if (!type.getName().equalsIgnoreCase(name)) continue;
                return fileSchema.getFieldIndex(type.getName());
            }
            return -1;
        }
    }

    public static Type getParquetType(HiveColumnHandle column, MessageType messageType, boolean useParquetColumnNames) {
        if (useParquetColumnNames) {
            return ParquetTypeUtils.getParquetTypeByName(column.getName(), messageType);
        }
        if (column.getHiveColumnIndex() < messageType.getFieldCount()) {
            return messageType.getType(column.getHiveColumnIndex());
        }
        return null;
    }

    public static ParquetEncoding getParquetEncoding(Encoding encoding) {
        switch (encoding) {
            case PLAIN: {
                return ParquetEncoding.PLAIN;
            }
            case RLE: {
                return ParquetEncoding.RLE;
            }
            case BIT_PACKED: {
                return ParquetEncoding.BIT_PACKED;
            }
            case PLAIN_DICTIONARY: {
                return ParquetEncoding.PLAIN_DICTIONARY;
            }
            case DELTA_BINARY_PACKED: {
                return ParquetEncoding.DELTA_BINARY_PACKED;
            }
            case DELTA_LENGTH_BYTE_ARRAY: {
                return ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY;
            }
            case DELTA_BYTE_ARRAY: {
                return ParquetEncoding.DELTA_BYTE_ARRAY;
            }
            case RLE_DICTIONARY: {
                return ParquetEncoding.RLE_DICTIONARY;
            }
        }
        throw new ParquetDecodingException("Unsupported Parquet encoding: " + encoding);
    }

    private static Type getParquetTypeByName(String columnName, MessageType messageType) {
        if (messageType.containsField(columnName)) {
            return messageType.getType(columnName);
        }
        for (Type type : messageType.getFields()) {
            if (!type.getName().equalsIgnoreCase(columnName)) continue;
            return type;
        }
        return null;
    }

    public static Optional<com.facebook.presto.spi.type.Type> createDecimalType(RichColumnDescriptor descriptor) {
        if (descriptor.getPrimitiveType().getOriginalType() != OriginalType.DECIMAL) {
            return Optional.empty();
        }
        DecimalMetadata decimalMetadata = descriptor.getPrimitiveType().getDecimalMetadata();
        return Optional.of(DecimalType.createDecimalType((int)decimalMetadata.getPrecision(), (int)decimalMetadata.getScale()));
    }
}

