/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;

public class HiveTransactionManager {
    private final ConcurrentMap<ConnectorTransactionHandle, ConnectorMetadata> transactions = new ConcurrentHashMap<ConnectorTransactionHandle, ConnectorMetadata>();

    @Inject
    public HiveTransactionManager() {
    }

    public ConnectorMetadata get(ConnectorTransactionHandle transactionHandle) {
        return (ConnectorMetadata)this.transactions.get(transactionHandle);
    }

    public ConnectorMetadata remove(ConnectorTransactionHandle transactionHandle) {
        return (ConnectorMetadata)this.transactions.remove(transactionHandle);
    }

    public void put(ConnectorTransactionHandle transactionHandle, ConnectorMetadata metadata) {
        ConnectorMetadata previousValue = this.transactions.putIfAbsent(transactionHandle, metadata);
        Preconditions.checkState(previousValue == null);
    }
}

