/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.hive.HiveSplit;
import com.facebook.presto.hive.HiveSplitLoader;
import com.facebook.presto.hive.HiveTypeName;
import com.facebook.presto.hive.InternalHiveSplit;
import com.facebook.presto.hive.util.AsyncQueue;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

class HiveSplitSource
implements ConnectorSplitSource {
    private static final Logger log = Logger.get(HiveSplit.class);
    private final String connectorId;
    private final String queryId;
    private final String databaseName;
    private final String tableName;
    private final TupleDomain<? extends ColumnHandle> compactEffectivePredicate;
    private final AsyncQueue<InternalHiveSplit> queue;
    private final int maxOutstandingSplitsBytes;
    private final AtomicReference<Throwable> throwable = new AtomicReference();
    private final HiveSplitLoader splitLoader;
    private volatile boolean closed;
    private final AtomicLong estimatedSplitSizeInBytes = new AtomicLong();
    private final CounterStat highMemorySplitSourceCounter;
    private final AtomicBoolean loggedHighMemoryWarning = new AtomicBoolean();

    HiveSplitSource(String connectorId, String queryId, String databaseName, String tableName, TupleDomain<? extends ColumnHandle> compactEffectivePredicate, int maxOutstandingSplits, DataSize maxOutstandingSplitsSize, HiveSplitLoader splitLoader, Executor executor, CounterStat highMemorySplitSourceCounter) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.databaseName = Objects.requireNonNull(databaseName, "databaseName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.queue = new AsyncQueue(maxOutstandingSplits, executor);
        this.maxOutstandingSplitsBytes = Math.toIntExact(maxOutstandingSplitsSize.toBytes());
        this.splitLoader = Objects.requireNonNull(splitLoader, "splitLoader is null");
        this.highMemorySplitSourceCounter = Objects.requireNonNull(highMemorySplitSourceCounter, "highMemorySplitSourceCounter is null");
    }

    @VisibleForTesting
    int getOutstandingSplitCount() {
        return this.queue.size();
    }

    CompletableFuture<?> addToQueue(Iterator<? extends InternalHiveSplit> splits) {
        CompletableFuture<Object> lastResult = CompletableFuture.completedFuture(null);
        while (splits.hasNext()) {
            InternalHiveSplit split = splits.next();
            lastResult = this.addToQueue(split);
        }
        return lastResult;
    }

    CompletableFuture<?> addToQueue(InternalHiveSplit split) {
        if (this.throwable.get() == null) {
            if (this.estimatedSplitSizeInBytes.addAndGet(split.getEstimatedSizeInBytes()) > (long)this.maxOutstandingSplitsBytes && this.loggedHighMemoryWarning.compareAndSet(false, true)) {
                this.highMemorySplitSourceCounter.update(1L);
                log.warn("Split buffering for %s.%s in query %s exceeded memory limit (%s). %s splits are buffered.", this.databaseName, this.tableName, this.queryId, DataSize.succinctBytes(this.maxOutstandingSplitsBytes), this.getOutstandingSplitCount());
            }
            return this.queue.offer(split);
        }
        return CompletableFuture.completedFuture(null);
    }

    void noMoreSplits() {
        if (this.throwable.get() == null) {
            this.splitLoader.stop();
            this.queue.finish();
        }
    }

    void fail(Throwable e) {
        if (this.throwable.compareAndSet(null, e)) {
            this.splitLoader.stop();
            this.queue.finish();
        }
    }

    public CompletableFuture<List<ConnectorSplit>> getNextBatch(int maxSize) {
        Preconditions.checkState(!this.closed, "Provider is already closed");
        CompletionStage future = this.queue.getBatchAsync(maxSize).thenApply(internalSplits -> {
            ImmutableList.Builder result = ImmutableList.builder();
            int totalEstimatedSizeInBytes = 0;
            for (InternalHiveSplit internalSplit : internalSplits) {
                totalEstimatedSizeInBytes += internalSplit.getEstimatedSizeInBytes();
                result.add(new HiveSplit(this.connectorId, this.databaseName, this.tableName, internalSplit.getPartitionName(), internalSplit.getPath(), internalSplit.getStart(), internalSplit.getLength(), internalSplit.getFileSize(), internalSplit.getSchema(), internalSplit.getPartitionKeys(), internalSplit.getAddresses(), internalSplit.getBucketNumber(), internalSplit.isForceLocalScheduling(), this.compactEffectivePredicate, Maps.transformValues(internalSplit.getColumnCoercions(), HiveTypeName::toHiveType)));
            }
            this.estimatedSplitSizeInBytes.addAndGet(-totalEstimatedSizeInBytes);
            return result.build();
        });
        if (this.throwable.get() != null) {
            return MoreFutures.failedFuture((Throwable)this.throwable.get());
        }
        return future;
    }

    public boolean isFinished() {
        boolean isFinished = this.queue.isFinished();
        if (this.throwable.get() != null) {
            throw HiveSplitSource.propagatePrestoException(this.throwable.get());
        }
        return isFinished;
    }

    public void close() {
        this.splitLoader.stop();
        this.queue.finish();
        this.closed = true;
    }

    private static RuntimeException propagatePrestoException(Throwable throwable) {
        if (throwable instanceof PrestoException) {
            throw (PrestoException)throwable;
        }
        if (throwable instanceof FileNotFoundException) {
            throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_NOT_FOUND, throwable);
        }
        throw new PrestoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNKNOWN_ERROR, throwable);
    }
}

