/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.auth;

import com.amazonaws.AmazonClientException;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.EC2CredentialsFetcher;
import com.amazonaws.internal.CredentialsEndpointProvider;
import com.amazonaws.internal.EC2CredentialsUtils;
import com.amazonaws.util.EC2MetadataUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class InstanceProfileCredentialsProvider
implements AWSCredentialsProvider,
Closeable {
    private static final Log LOG = LogFactory.getLog(InstanceProfileCredentialsProvider.class);
    private static final int ASYNC_REFRESH_INTERVAL_TIME_MINUTES = 1;
    private static final InstanceProfileCredentialsProvider INSTANCE = new InstanceProfileCredentialsProvider();
    private final EC2CredentialsFetcher credentialsFetcher = new EC2CredentialsFetcher(new InstanceMetadataCredentialsEndpointProvider());
    private volatile ScheduledExecutorService executor;
    private volatile boolean shouldRefresh = false;

    @Deprecated
    public InstanceProfileCredentialsProvider() {
        this(false);
    }

    public InstanceProfileCredentialsProvider(boolean refreshCredentialsAsync) {
        this(refreshCredentialsAsync, true);
    }

    public static InstanceProfileCredentialsProvider createAsyncRefreshingProvider(boolean eagerlyRefreshCredentialsAsync) {
        return new InstanceProfileCredentialsProvider(true, eagerlyRefreshCredentialsAsync);
    }

    private InstanceProfileCredentialsProvider(boolean refreshCredentialsAsync, boolean eagerlyRefreshCredentialsAsync) {
        this.shouldRefresh = eagerlyRefreshCredentialsAsync;
        if (refreshCredentialsAsync) {
            this.executor = Executors.newScheduledThreadPool(1);
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (InstanceProfileCredentialsProvider.this.shouldRefresh) {
                            InstanceProfileCredentialsProvider.this.credentialsFetcher.getCredentials();
                        }
                    }
                    catch (AmazonClientException ace) {
                        InstanceProfileCredentialsProvider.this.handleError(ace);
                    }
                    catch (RuntimeException re) {
                        InstanceProfileCredentialsProvider.this.handleError(re);
                    }
                }
            }, 0L, 1L, TimeUnit.MINUTES);
        }
    }

    public static InstanceProfileCredentialsProvider getInstance() {
        return INSTANCE;
    }

    private void handleError(Throwable t) {
        this.refresh();
        LOG.error(t.getMessage(), t);
    }

    protected void finalize() throws Throwable {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    @Override
    public AWSCredentials getCredentials() {
        AWSCredentials creds = this.credentialsFetcher.getCredentials();
        this.shouldRefresh = true;
        return creds;
    }

    @Override
    public void refresh() {
        this.credentialsFetcher.refresh();
    }

    @Override
    public void close() throws IOException {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    private static class InstanceMetadataCredentialsEndpointProvider
    extends CredentialsEndpointProvider {
        private InstanceMetadataCredentialsEndpointProvider() {
        }

        @Override
        public URI getCredentialsEndpoint() throws URISyntaxException, IOException {
            String host = EC2MetadataUtils.getHostAddressForEC2MetadataService();
            String securityCredentialsList = EC2CredentialsUtils.getInstance().readResource(new URI(host + "/latest/meta-data/iam/security-credentials/"));
            String[] securityCredentials = securityCredentialsList.trim().split("\n");
            if (securityCredentials.length == 0) {
                throw new SdkClientException("Unable to load credentials path");
            }
            return new URI(host + "/latest/meta-data/iam/security-credentials/" + securityCredentials[0]);
        }
    }
}

