/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.writer;

import com.amazonaws.services.s3.model.PartETag;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.util.Preconditions;

public final class S3Recoverable
implements RecoverableWriter.ResumeRecoverable {
    private final String uploadId;
    private final String objectName;
    private final List<PartETag> parts;
    @Nullable
    private final String lastPartObject;
    private long numBytesInParts;
    private long lastPartObjectLength;

    S3Recoverable(String objectName, String uploadId, List<PartETag> parts, long numBytesInParts) {
        this(objectName, uploadId, parts, numBytesInParts, null, -1L);
    }

    S3Recoverable(String objectName, String uploadId, List<PartETag> parts, long numBytesInParts, @Nullable String lastPartObject, long lastPartObjectLength) {
        Preconditions.checkArgument((numBytesInParts >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((lastPartObject == null || lastPartObjectLength > 0L ? 1 : 0) != 0);
        this.objectName = (String)Preconditions.checkNotNull((Object)objectName);
        this.uploadId = (String)Preconditions.checkNotNull((Object)uploadId);
        this.parts = (List)Preconditions.checkNotNull(parts);
        this.numBytesInParts = numBytesInParts;
        this.lastPartObject = lastPartObject;
        this.lastPartObjectLength = lastPartObjectLength;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public List<PartETag> parts() {
        return this.parts;
    }

    public long numBytesInParts() {
        return this.numBytesInParts;
    }

    @Nullable
    public String incompleteObjectName() {
        return this.lastPartObject;
    }

    public long incompleteObjectLength() {
        return this.lastPartObjectLength;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("S3Recoverable: ");
        buf.append("key=").append(this.objectName);
        buf.append(", uploadId=").append(this.uploadId);
        buf.append(", bytesInParts=").append(this.numBytesInParts);
        buf.append(", parts=[");
        int num = 0;
        for (PartETag part : this.parts) {
            if (0 != num++) {
                buf.append(", ");
            }
            buf.append(part.getPartNumber()).append('=').append(part.getETag());
        }
        buf.append("], trailingPart=").append(this.lastPartObject);
        buf.append("trailingPartLen=").append(this.lastPartObjectLength);
        return buf.toString();
    }
}

