/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.token;

import com.amazonaws.SdkBaseException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.securitytoken.model.Credentials;
import org.apache.flink.annotation.Internal;
import org.apache.flink.fs.s3.common.token.S3DelegationTokenReceiver;
import org.apache.hadoop.fs.s3a.auth.NoAwsCredentialsException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class DynamicTemporaryAWSCredentialsProvider
implements AWSCredentialsProvider {
    public static final String NAME = DynamicTemporaryAWSCredentialsProvider.class.getName();
    public static final String COMPONENT = "Dynamic session credentials for Flink";
    private static final Logger LOG = LoggerFactory.getLogger(DynamicTemporaryAWSCredentialsProvider.class);

    @Override
    public AWSCredentials getCredentials() throws SdkBaseException {
        Credentials credentials = S3DelegationTokenReceiver.getCredentials();
        if (credentials == null) {
            throw new NoAwsCredentialsException(COMPONENT);
        }
        LOG.debug("Providing session credentials");
        return new BasicSessionCredentials(credentials.getAccessKeyId(), credentials.getSecretAccessKey(), credentials.getSessionToken());
    }

    @Override
    public void refresh() {
    }
}

