/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.fs.s3.common.writer;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.fs.Path;
import org.apache.flink.fs.s3.common.utils.BackPressuringExecutor;
import org.apache.flink.fs.s3.common.utils.RefCountedFileWithStream;
import org.apache.flink.fs.s3.common.writer.RecoverableMultiPartUpload;
import org.apache.flink.fs.s3.common.writer.RecoverableMultiPartUploadImpl;
import org.apache.flink.fs.s3.common.writer.S3AccessHelper;
import org.apache.flink.fs.s3.common.writer.S3Recoverable;
import org.apache.flink.fs.s3hadoop.common.HadoopFileSystem;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;
import org.apache.hadoop.fs.FileSystem;

@Internal
final class S3RecoverableMultipartUploadFactory {
    private final FileSystem fs;
    private final S3AccessHelper s3AccessHelper;
    private final FunctionWithException<File, RefCountedFileWithStream, IOException> tmpFileSupplier;
    private final int maxConcurrentUploadsPerStream;
    private final Executor executor;

    S3RecoverableMultipartUploadFactory(FileSystem fs, S3AccessHelper s3AccessHelper, int maxConcurrentUploadsPerStream, Executor executor, FunctionWithException<File, RefCountedFileWithStream, IOException> tmpFileSupplier) {
        this.fs = (FileSystem)Preconditions.checkNotNull((Object)fs);
        this.maxConcurrentUploadsPerStream = maxConcurrentUploadsPerStream;
        this.executor = executor;
        this.s3AccessHelper = s3AccessHelper;
        this.tmpFileSupplier = tmpFileSupplier;
    }

    RecoverableMultiPartUpload getNewRecoverableUpload(Path path) throws IOException {
        return RecoverableMultiPartUploadImpl.newUpload(this.s3AccessHelper, this.limitedExecutor(), this.pathToObjectName(path));
    }

    RecoverableMultiPartUpload recoverRecoverableUpload(S3Recoverable recoverable) throws IOException {
        Optional<File> incompletePart = this.recoverInProgressPart(recoverable);
        return RecoverableMultiPartUploadImpl.recoverUpload(this.s3AccessHelper, this.limitedExecutor(), recoverable.uploadId(), recoverable.getObjectName(), recoverable.parts(), recoverable.numBytesInParts(), incompletePart);
    }

    private Optional<File> recoverInProgressPart(S3Recoverable recoverable) throws IOException {
        String objectKey = recoverable.incompleteObjectName();
        if (objectKey == null) {
            return Optional.empty();
        }
        RefCountedFileWithStream refCountedFile = (RefCountedFileWithStream)((Object)this.tmpFileSupplier.apply(null));
        File file = refCountedFile.getFile();
        long numBytes = this.s3AccessHelper.getObject(objectKey, file);
        if (numBytes != recoverable.incompleteObjectLength()) {
            throw new IOException(String.format("Error recovering writer: Downloading the last data chunk file gives incorrect length.File length is %d bytes, RecoveryData indicates %d bytes", numBytes, recoverable.incompleteObjectLength()));
        }
        return Optional.of(file);
    }

    private String pathToObjectName(Path path) {
        org.apache.hadoop.fs.Path hadoopPath = HadoopFileSystem.toHadoopPath(path);
        if (!hadoopPath.isAbsolute()) {
            hadoopPath = new org.apache.hadoop.fs.Path(this.fs.getWorkingDirectory(), hadoopPath);
        }
        return hadoopPath.toUri().getScheme() != null && hadoopPath.toUri().getPath().isEmpty() ? "" : hadoopPath.toUri().getPath().substring(1);
    }

    private Executor limitedExecutor() {
        return this.maxConcurrentUploadsPerStream <= 0 ? this.executor : new BackPressuringExecutor(this.executor, this.maxConcurrentUploadsPerStream);
    }
}

