/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3native.S3xLoginHelper;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class SimpleAWSCredentialsProvider
implements AWSCredentialsProvider {
    public static final String NAME = "org.apache.hadoop.fs.s3a.SimpleAWSCredentialsProvider";
    private String accessKey;
    private String secretKey;

    public SimpleAWSCredentialsProvider(URI uri, Configuration conf) throws IOException {
        S3xLoginHelper.Login login = S3AUtils.getAWSAccessKeys(uri, conf);
        this.accessKey = login.getUser();
        this.secretKey = login.getPassword();
    }

    @Override
    public AWSCredentials getCredentials() {
        if (!StringUtils.isEmpty(this.accessKey) && !StringUtils.isEmpty(this.secretKey)) {
            return new BasicAWSCredentials(this.accessKey, this.secretKey);
        }
        throw new CredentialInitializationException("Access key or secret key is unset");
    }

    @Override
    public void refresh() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

