/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderExtension;

public class CachingKeyProvider
extends KeyProviderExtension<CacheExtension> {
    public CachingKeyProvider(KeyProvider keyProvider, long keyTimeoutMillis, long currKeyTimeoutMillis) {
        super(keyProvider, new CacheExtension(keyProvider, keyTimeoutMillis, currKeyTimeoutMillis));
    }

    @Override
    public KeyProvider.KeyVersion getCurrentKey(String name) throws IOException {
        try {
            return (KeyProvider.KeyVersion)((CacheExtension)this.getExtension()).currentKeyCache.get(name);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof KeyNotFoundException) {
                return null;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
    }

    @Override
    public KeyProvider.KeyVersion getKeyVersion(String versionName) throws IOException {
        try {
            return (KeyProvider.KeyVersion)((CacheExtension)this.getExtension()).keyVersionCache.get(versionName);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof KeyNotFoundException) {
                return null;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
    }

    @Override
    public void deleteKey(String name) throws IOException {
        this.getKeyProvider().deleteKey(name);
        ((CacheExtension)this.getExtension()).currentKeyCache.invalidate(name);
        ((CacheExtension)this.getExtension()).keyMetadataCache.invalidate(name);
        ((CacheExtension)this.getExtension()).keyVersionCache.invalidateAll();
    }

    @Override
    public KeyProvider.KeyVersion rollNewVersion(String name, byte[] material) throws IOException {
        KeyProvider.KeyVersion key = this.getKeyProvider().rollNewVersion(name, material);
        this.invalidateCache(name);
        return key;
    }

    @Override
    public KeyProvider.KeyVersion rollNewVersion(String name) throws NoSuchAlgorithmException, IOException {
        KeyProvider.KeyVersion key = this.getKeyProvider().rollNewVersion(name);
        this.invalidateCache(name);
        return key;
    }

    @Override
    public void invalidateCache(String name) throws IOException {
        this.getKeyProvider().invalidateCache(name);
        ((CacheExtension)this.getExtension()).currentKeyCache.invalidate(name);
        ((CacheExtension)this.getExtension()).keyMetadataCache.invalidate(name);
        ((CacheExtension)this.getExtension()).keyVersionCache.invalidateAll();
    }

    @Override
    public KeyProvider.Metadata getMetadata(String name) throws IOException {
        try {
            return (KeyProvider.Metadata)((CacheExtension)this.getExtension()).keyMetadataCache.get(name);
        }
        catch (ExecutionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof KeyNotFoundException) {
                return null;
            }
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
    }

    private static class KeyNotFoundException
    extends Exception {
        private KeyNotFoundException() {
        }
    }

    static class CacheExtension
    implements KeyProviderExtension.Extension {
        private final KeyProvider provider;
        private LoadingCache<String, KeyProvider.KeyVersion> keyVersionCache;
        private LoadingCache<String, KeyProvider.KeyVersion> currentKeyCache;
        private LoadingCache<String, KeyProvider.Metadata> keyMetadataCache;

        CacheExtension(KeyProvider prov, long keyTimeoutMillis, long currKeyTimeoutMillis) {
            this.provider = prov;
            this.keyVersionCache = CacheBuilder.newBuilder().expireAfterAccess(keyTimeoutMillis, TimeUnit.MILLISECONDS).build(new CacheLoader<String, KeyProvider.KeyVersion>(){

                @Override
                public KeyProvider.KeyVersion load(String key) throws Exception {
                    KeyProvider.KeyVersion kv = provider.getKeyVersion(key);
                    if (kv == null) {
                        throw new KeyNotFoundException();
                    }
                    return kv;
                }
            });
            this.keyMetadataCache = CacheBuilder.newBuilder().expireAfterAccess(keyTimeoutMillis, TimeUnit.MILLISECONDS).build(new CacheLoader<String, KeyProvider.Metadata>(){

                @Override
                public KeyProvider.Metadata load(String key) throws Exception {
                    KeyProvider.Metadata meta = provider.getMetadata(key);
                    if (meta == null) {
                        throw new KeyNotFoundException();
                    }
                    return meta;
                }
            });
            this.currentKeyCache = CacheBuilder.newBuilder().expireAfterWrite(currKeyTimeoutMillis, TimeUnit.MILLISECONDS).build(new CacheLoader<String, KeyProvider.KeyVersion>(){

                @Override
                public KeyProvider.KeyVersion load(String key) throws Exception {
                    KeyProvider.KeyVersion kv = provider.getCurrentKey(key);
                    if (kv == null) {
                        throw new KeyNotFoundException();
                    }
                    return kv;
                }
            });
        }
    }
}

