/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import com.amazonaws.services.s3.model.MultipartUpload;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.Invoker;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.commit.CommitOperations;
import org.apache.hadoop.fs.s3a.commit.CommitUtils;
import org.apache.hadoop.fs.s3a.commit.CommitUtilsWithMR;
import org.apache.hadoop.fs.s3a.commit.DurationInfo;
import org.apache.hadoop.fs.s3a.commit.PathCommitException;
import org.apache.hadoop.fs.s3a.commit.Tasks;
import org.apache.hadoop.fs.s3a.commit.files.PendingSet;
import org.apache.hadoop.fs.s3a.commit.files.SinglePendingCommit;
import org.apache.hadoop.fs.s3a.commit.files.SuccessData;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.net.NetUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractS3ACommitter
extends PathOutputCommitter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractS3ACommitter.class);
    private ExecutorService threadPool;
    private final CommitOperations commitOperations;
    private Path outputPath;
    private final String role;
    private Path workPath;
    private Configuration conf;
    private FileSystem destFS;
    private final JobContext jobContext;
    private final boolean createJobMarker;

    protected AbstractS3ACommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        Preconditions.checkArgument(outputPath != null, "null output path");
        Preconditions.checkArgument(context != null, "null job context");
        this.jobContext = context;
        this.role = "Task committer " + context.getTaskAttemptID();
        this.setConf(context.getConfiguration());
        this.initOutput(outputPath);
        LOG.debug("{} instantiated for job \"{}\" ID {} with destination {}", new Object[]{this.role, CommitUtilsWithMR.jobName((JobContext)context), CommitUtilsWithMR.jobIdString((JobContext)context), outputPath});
        S3AFileSystem fs = this.getDestS3AFS();
        this.createJobMarker = context.getConfiguration().getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", true);
        this.commitOperations = new CommitOperations(fs);
    }

    @VisibleForTesting
    protected void initOutput(Path out) throws IOException {
        FileSystem fs = this.getDestinationFS(out, this.getConf());
        this.setDestFS(fs);
        this.setOutputPath(fs.makeQualified(out));
    }

    public final JobContext getJobContext() {
        return this.jobContext;
    }

    public final Path getOutputPath() {
        return this.outputPath;
    }

    protected final void setOutputPath(Path outputPath) {
        Preconditions.checkNotNull(outputPath, "Null output path");
        this.outputPath = outputPath;
    }

    public Path getWorkPath() {
        return this.workPath;
    }

    protected void setWorkPath(Path workPath) {
        LOG.debug("Setting work path to {}", (Object)workPath);
        this.workPath = workPath;
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected void setConf(Configuration conf) {
        this.conf = conf;
    }

    public FileSystem getDestFS() throws IOException {
        if (this.destFS == null) {
            FileSystem fs = this.getDestinationFS(this.outputPath, this.getConf());
            this.setDestFS(fs);
        }
        return this.destFS;
    }

    public S3AFileSystem getDestS3AFS() throws IOException {
        return (S3AFileSystem)this.getDestFS();
    }

    protected void setDestFS(FileSystem destFS) {
        this.destFS = destFS;
    }

    public Path getJobAttemptPath(JobContext context) {
        return this.getJobAttemptPath(CommitUtilsWithMR.getAppAttemptId(context));
    }

    protected abstract Path getJobAttemptPath(int var1);

    public Path getTaskAttemptPath(TaskAttemptContext context) {
        return this.getBaseTaskAttemptPath(context);
    }

    protected abstract Path getBaseTaskAttemptPath(TaskAttemptContext var1);

    public abstract Path getTempTaskAttemptPath(TaskAttemptContext var1);

    public abstract String getName();

    public String toString() {
        StringBuilder sb = new StringBuilder("AbstractS3ACommitter{");
        sb.append("role=").append(this.role);
        sb.append(", name=").append(this.getName());
        sb.append(", outputPath=").append(this.getOutputPath());
        sb.append(", workPath=").append(this.workPath);
        sb.append('}');
        return sb.toString();
    }

    protected FileSystem getDestinationFS(Path out, Configuration config) throws IOException {
        return CommitUtils.getS3AFileSystem(out, config, this.requiresDelayedCommitOutputInFileSystem());
    }

    protected boolean requiresDelayedCommitOutputInFileSystem() {
        return false;
    }

    public void recoverTask(TaskAttemptContext taskContext) throws IOException {
        LOG.warn("Cannot recover task {}", (Object)taskContext.getTaskAttemptID());
        throw new PathCommitException(this.outputPath, String.format("Unable to recover task %s", taskContext.getTaskAttemptID()));
    }

    protected void maybeCreateSuccessMarkerFromCommits(JobContext context, List<SinglePendingCommit> pending) throws IOException {
        ArrayList<String> filenames = new ArrayList<String>(pending.size());
        for (SinglePendingCommit commit : pending) {
            String key = commit.getDestinationKey();
            if (!key.startsWith("/")) {
                key = "/" + key;
            }
            filenames.add(key);
        }
        this.maybeCreateSuccessMarker(context, filenames);
    }

    protected void maybeCreateSuccessMarker(JobContext context, List<String> filenames) throws IOException {
        if (this.createJobMarker) {
            SuccessData successData = new SuccessData();
            successData.setCommitter(this.getName());
            successData.setDescription(this.getRole());
            successData.setHostname(NetUtils.getLocalHostname());
            Date now = new Date();
            successData.setTimestamp(now.getTime());
            successData.setDate(now.toString());
            successData.setFilenames(filenames);
            this.commitOperations.createSuccessMarker(this.getOutputPath(), successData, true);
        }
    }

    public void setupTask(TaskAttemptContext context) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Setup Task %s", context.getTaskAttemptID());){
            Path taskAttemptPath = this.getTaskAttemptPath(context);
            FileSystem fs = this.getTaskAttemptFilesystem(context);
            fs.mkdirs(taskAttemptPath);
        }
    }

    protected FileSystem getTaskAttemptFilesystem(TaskAttemptContext context) throws IOException {
        return this.getTaskAttemptPath(context).getFileSystem(this.getConf());
    }

    protected void commitPendingUploads(JobContext context, List<SinglePendingCommit> pending) throws IOException {
        if (pending.isEmpty()) {
            LOG.warn("{}: No pending uploads to commit", (Object)this.getRole());
        }
        LOG.debug("{}: committing the output of {} task(s)", (Object)this.getRole(), (Object)pending.size());
        Tasks.foreach(pending).stopOnFailure().executeWith(this.buildThreadPool(context)).onFailure((commit, exception) -> this.getCommitOperations().abortSingleCommit((SinglePendingCommit)commit)).abortWith(commit -> this.getCommitOperations().abortSingleCommit((SinglePendingCommit)commit)).revertWith(commit -> this.getCommitOperations().revertCommit((SinglePendingCommit)commit)).run(commit -> this.getCommitOperations().commitOrFail((SinglePendingCommit)commit));
    }

    protected List<SinglePendingCommit> loadPendingsetFiles(JobContext context, boolean suppressExceptions, FileSystem fs, Iterable<? extends FileStatus> pendingCommitFiles) throws IOException {
        List<SinglePendingCommit> pending = Collections.synchronizedList(Lists.newArrayList());
        Tasks.foreach(pendingCommitFiles).suppressExceptions(suppressExceptions).executeWith(this.buildThreadPool(context)).run(pendingCommitFile -> pending.addAll(PendingSet.load(fs, pendingCommitFile.getPath()).getCommits()));
        return pending;
    }

    protected void commitJobInternal(JobContext context, List<SinglePendingCommit> pending) throws IOException {
        this.commitPendingUploads(context, pending);
    }

    public void abortJob(JobContext context, JobStatus.State state) throws IOException {
        LOG.info("{}: aborting job {} in state {}", new Object[]{this.getRole(), CommitUtilsWithMR.jobIdString(context), state});
        this.abortJobInternal(context, false);
    }

    protected void abortJobInternal(JobContext context, boolean suppressExceptions) throws IOException {
        this.cleanup(context, suppressExceptions);
    }

    protected void abortPendingUploadsInCleanup(boolean suppressExceptions) throws IOException {
        Path dest = this.getOutputPath();
        try (DurationInfo d = new DurationInfo(LOG, "Aborting all pending commits under %s", dest);){
            List<MultipartUpload> pending;
            CommitOperations ops = this.getCommitOperations();
            try {
                pending = ops.listPendingUploadsUnderPath(dest);
            }
            catch (IOException e) {
                this.maybeIgnore(suppressExceptions, "aborting pending uploads", e);
                if (d != null) {
                    if (var4_4 != null) {
                        try {
                            d.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        d.close();
                    }
                }
                return;
            }
            Tasks.foreach(pending).executeWith(this.buildThreadPool(this.getJobContext())).suppressExceptions(suppressExceptions).run(u -> ops.abortMultipartCommit(u.getKey(), u.getUploadId()));
        }
    }

    protected void preCommitJob(JobContext context, List<SinglePendingCommit> pending) throws IOException {
    }

    public void commitJob(JobContext context) throws IOException {
        String id = CommitUtilsWithMR.jobIdString(context);
        try (DurationInfo d = new DurationInfo(LOG, "%s: commitJob(%s)", this.getRole(), id);){
            List<SinglePendingCommit> pending = this.listPendingUploadsToCommit(context);
            this.preCommitJob(context, pending);
            this.commitJobInternal(context, pending);
            this.jobCompleted(true);
            this.maybeCreateSuccessMarkerFromCommits(context, pending);
            this.cleanup(context, false);
        }
        catch (IOException e) {
            LOG.warn("Commit failure for job {}", (Object)id, (Object)e);
            this.jobCompleted(false);
            this.abortJobInternal(context, true);
            throw e;
        }
    }

    protected void jobCompleted(boolean success) {
        this.getCommitOperations().jobCompleted(success);
    }

    public abstract void cleanupStagingDirs();

    protected abstract List<SinglePendingCommit> listPendingUploadsToCommit(JobContext var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(JobContext context, boolean suppressExceptions) throws IOException {
        try (DurationInfo d = new DurationInfo(LOG, "Cleanup job %s", CommitUtilsWithMR.jobIdString(context));){
            this.abortPendingUploadsInCleanup(suppressExceptions);
        }
        finally {
            this.cleanupStagingDirs();
        }
    }

    public void cleanupJob(JobContext context) throws IOException {
        String r = this.getRole();
        String id = CommitUtilsWithMR.jobIdString(context);
        LOG.warn("{}: using deprecated cleanupJob call for {}", (Object)r, (Object)id);
        try (DurationInfo d = new DurationInfo(LOG, "%s: cleanup Job %s", r, id);){
            this.cleanup(context, true);
        }
    }

    protected void maybeIgnore(boolean suppress, String action, Invoker.VoidOperation operation) throws IOException {
        if (suppress) {
            Invoker.ignoreIOExceptions(LOG, action, "", operation);
        } else {
            operation.execute();
        }
    }

    protected void maybeIgnore(boolean suppress, String action, IOException ex) throws IOException {
        if (!suppress) {
            throw ex;
        }
        LOG.debug(action, (Throwable)ex);
    }

    protected CommitOperations getCommitOperations() {
        return this.commitOperations;
    }

    protected String getRole() {
        return this.role;
    }

    protected final synchronized ExecutorService buildThreadPool(JobContext context) {
        if (this.threadPool == null) {
            int numThreads = context.getConfiguration().getInt("fs.s3a.committer.threads", 8);
            LOG.debug("{}: creating thread pool of size {}", (Object)this.getRole(), (Object)numThreads);
            if (numThreads > 0) {
                this.threadPool = Executors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("s3-committer-pool-%d").build());
            } else {
                return null;
            }
        }
        return this.threadPool;
    }

    protected void deleteTaskAttemptPathQuietly(TaskAttemptContext context) {
        Path attemptPath = this.getBaseTaskAttemptPath(context);
        Invoker.ignoreIOExceptions(LOG, "Delete task attempt path", attemptPath.toString(), () -> S3AUtils.deleteQuietly(this.getTaskAttemptFilesystem(context), attemptPath, true));
    }

    protected void abortPendingUploads(JobContext context, List<SinglePendingCommit> pending, boolean suppressExceptions) throws IOException {
        if (pending == null || pending.isEmpty()) {
            LOG.info("{}: no pending commits to abort", (Object)this.getRole());
        } else {
            try (DurationInfo d = new DurationInfo(LOG, "Aborting %s uploads", pending.size());){
                Tasks.foreach(pending).executeWith(this.buildThreadPool(context)).suppressExceptions(suppressExceptions).run(commit -> this.getCommitOperations().abortSingleCommit((SinglePendingCommit)commit));
            }
        }
    }
}

