/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.Collection;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.state.KeyedStateBackend;
import org.apache.flink.runtime.state.internal.InternalReducingState;
import org.apache.flink.runtime.state.metrics.AbstractMetricsTrackState;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.SizeTrackingStateConfig;
import org.apache.flink.runtime.state.metrics.StateMetricBase;
import org.apache.flink.util.function.ThrowingRunnable;

class MetricsTrackingReducingState<K, N, T>
extends AbstractMetricsTrackState<K, N, T, InternalReducingState<K, N, T>, ReducingStateMetrics>
implements InternalReducingState<K, N, T> {
    MetricsTrackingReducingState(String stateName, InternalReducingState<K, N, T> original, KeyedStateBackend<K> keyedStateBackend, LatencyTrackingStateConfig latencyTrackingStateConfig, SizeTrackingStateConfig sizeTrackingStateConfig) {
        super(original, keyedStateBackend, new ReducingStateMetrics(stateName, latencyTrackingStateConfig.getMetricGroup(), latencyTrackingStateConfig.getSampleInterval(), latencyTrackingStateConfig.getHistorySize(), latencyTrackingStateConfig.isStateNameAsVariable()), new ReducingStateMetrics(stateName, sizeTrackingStateConfig.getMetricGroup(), sizeTrackingStateConfig.getSampleInterval(), sizeTrackingStateConfig.getHistorySize(), sizeTrackingStateConfig.isStateNameAsVariable()));
    }

    public T get() throws Exception {
        Object result = this.latencyTrackingStateMetric != null && ((ReducingStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnGet() ? this.trackLatencyWithException(() -> ((InternalReducingState)this.original).get(), "reducingStateGetLatency") : ((InternalReducingState)this.original).get();
        if (this.sizeTrackingStateMetric != null && ((ReducingStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnGet()) {
            ((ReducingStateMetrics)this.sizeTrackingStateMetric).updateMetrics("reducingStateGetKeySize", super.sizeOfKey());
            ((ReducingStateMetrics)this.sizeTrackingStateMetric).updateMetrics("reducingStateGetValueSize", super.sizeOfValue(result));
        }
        return (T)result;
    }

    public void add(T value) throws Exception {
        if (this.sizeTrackingStateMetric != null && ((ReducingStateMetrics)this.sizeTrackingStateMetric).trackMetricsOnAdd()) {
            ((ReducingStateMetrics)this.sizeTrackingStateMetric).updateMetrics("reducingStateAddKeySize", super.sizeOfKey());
            ((ReducingStateMetrics)this.sizeTrackingStateMetric).updateMetrics("reducingStateAddValueSize", super.sizeOfValue(value));
        }
        if (this.latencyTrackingStateMetric != null && ((ReducingStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnAdd()) {
            this.trackLatencyWithException((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> ((InternalReducingState)this.original).add(value)), "reducingStateAddLatency");
        } else {
            ((InternalReducingState)this.original).add(value);
        }
    }

    @Override
    public T getInternal() throws Exception {
        return (T)((InternalReducingState)this.original).getInternal();
    }

    @Override
    public void updateInternal(T valueToStore) throws Exception {
        ((InternalReducingState)this.original).updateInternal(valueToStore);
    }

    @Override
    public void mergeNamespaces(N target, Collection<N> sources) throws Exception {
        if (this.latencyTrackingStateMetric != null && ((ReducingStateMetrics)this.latencyTrackingStateMetric).trackMetricsOnMergeNamespace()) {
            this.trackLatencyWithException((ThrowingRunnable<Exception>)((ThrowingRunnable)() -> ((InternalReducingState)this.original).mergeNamespaces(target, sources)), "reducingStateMergeNamespacesLatency");
        } else {
            ((InternalReducingState)this.original).mergeNamespaces(target, sources);
        }
    }

    protected static class ReducingStateMetrics
    extends StateMetricBase {
        private static final String REDUCING_STATE_GET_LATENCY = "reducingStateGetLatency";
        private static final String REDUCING_STATE_ADD_LATENCY = "reducingStateAddLatency";
        private static final String REDUCING_STATE_MERGE_NAMESPACES_LATENCY = "reducingStateMergeNamespacesLatency";
        private static final String REDUCING_STATE_GET_KEY_SIZE = "reducingStateGetKeySize";
        private static final String REDUCING_STATE_GET_VALUE_SIZE = "reducingStateGetValueSize";
        private static final String REDUCING_STATE_ADD_KEY_SIZE = "reducingStateAddKeySize";
        private static final String REDUCING_STATE_ADD_VALUE_SIZE = "reducingStateAddValueSize";
        private int getCount = 0;
        private int addCount = 0;
        private int mergeNamespaceCount = 0;

        ReducingStateMetrics(String stateName, MetricGroup metricGroup, int sampleInterval, int historySize, boolean stateNameAsVariable) {
            super(stateName, metricGroup, sampleInterval, historySize, stateNameAsVariable);
        }

        int getGetCount() {
            return this.getCount;
        }

        int getAddCount() {
            return this.addCount;
        }

        int getMergeNamespaceCount() {
            return this.mergeNamespaceCount;
        }

        private boolean trackMetricsOnGet() {
            this.getCount = this.loopUpdateCounter(this.getCount);
            return this.getCount == 1;
        }

        private boolean trackMetricsOnAdd() {
            this.addCount = this.loopUpdateCounter(this.addCount);
            return this.addCount == 1;
        }

        private boolean trackMetricsOnMergeNamespace() {
            this.mergeNamespaceCount = this.loopUpdateCounter(this.mergeNamespaceCount);
            return this.mergeNamespaceCount == 1;
        }
    }
}

