/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.memory;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStateOutputStream;
import org.apache.flink.runtime.state.CheckpointStateToolset;
import org.apache.flink.runtime.state.CheckpointStorageLocation;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.NotDuplicatingCheckpointStateToolset;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.runtime.state.memory.MemCheckpointStreamFactory;
import org.apache.flink.runtime.state.memory.NonPersistentMetadataCheckpointStorageLocation;
import org.apache.flink.runtime.state.memory.PersistentMetadataCheckpointStorageLocation;
import org.apache.flink.util.Preconditions;

public class MemoryBackendCheckpointStorageAccess
extends AbstractFsCheckpointStorageAccess {
    @Nullable
    private final Path checkpointsDirectory;
    @Nullable
    private final FileSystem fileSystem;
    private final int maxStateSize;

    public MemoryBackendCheckpointStorageAccess(JobID jobId, @Nullable Path checkpointsBaseDirectory, @Nullable Path defaultSavepointLocation, boolean createCheckpointSubDirs, int maxStateSize) throws IOException {
        super(jobId, defaultSavepointLocation);
        Preconditions.checkArgument((maxStateSize > 0 ? 1 : 0) != 0);
        this.maxStateSize = maxStateSize;
        if (checkpointsBaseDirectory == null) {
            this.checkpointsDirectory = null;
            this.fileSystem = null;
        } else {
            this.fileSystem = checkpointsBaseDirectory.getFileSystem();
            this.checkpointsDirectory = createCheckpointSubDirs ? MemoryBackendCheckpointStorageAccess.getCheckpointDirectoryForJob(checkpointsBaseDirectory, jobId) : checkpointsBaseDirectory;
        }
    }

    public int getMaxStateSize() {
        return this.maxStateSize;
    }

    @VisibleForTesting
    Path getCheckpointsDirectory() {
        return this.checkpointsDirectory;
    }

    @Override
    public boolean supportsHighlyAvailableStorage() {
        return this.checkpointsDirectory != null;
    }

    @Override
    public void initializeBaseLocationsForCheckpoint() {
    }

    @Override
    public CheckpointStorageLocation initializeLocationForCheckpoint(long checkpointId) throws IOException {
        Preconditions.checkArgument((checkpointId >= 0L ? 1 : 0) != 0);
        if (this.checkpointsDirectory != null) {
            Preconditions.checkState((this.fileSystem != null ? 1 : 0) != 0);
            Path checkpointDir = MemoryBackendCheckpointStorageAccess.createCheckpointDirectory(this.checkpointsDirectory, checkpointId);
            this.fileSystem.mkdirs(checkpointDir);
            return new PersistentMetadataCheckpointStorageLocation(this.fileSystem, checkpointDir, this.maxStateSize);
        }
        return new NonPersistentMetadataCheckpointStorageLocation(this.maxStateSize);
    }

    @Override
    public CheckpointStreamFactory resolveCheckpointStorageLocation(long checkpointId, CheckpointStorageLocationReference reference) {
        return new MemCheckpointStreamFactory(this.maxStateSize);
    }

    @Override
    public CheckpointStateOutputStream createTaskOwnedStateStream() {
        return new MemCheckpointStreamFactory.MemoryCheckpointOutputStream(this.maxStateSize);
    }

    @Override
    public CheckpointStateToolset createTaskOwnedCheckpointStateToolset() {
        return new NotDuplicatingCheckpointStateToolset();
    }

    @Override
    protected CheckpointStorageLocation createSavepointLocation(FileSystem fs, Path location) {
        return new PersistentMetadataCheckpointStorageLocation(fs, location, this.maxStateSize);
    }

    public String toString() {
        return "MemoryBackendCheckpointStorage {checkpointsDirectory=" + String.valueOf(this.checkpointsDirectory) + ", fileSystem=" + String.valueOf(this.fileSystem) + ", maxStateSize=" + this.maxStateSize + "}";
    }
}

