/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.heap;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.StateDescriptor;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.MapSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.queryablestate.client.state.serialization.KvStateSerializer;
import org.apache.flink.runtime.state.heap.AbstractHeapState;
import org.apache.flink.runtime.state.heap.StateTable;
import org.apache.flink.runtime.state.internal.InternalMapState;
import org.apache.flink.runtime.state.ttl.TtlAwareSerializer;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;
import org.apache.flink.runtime.state.ttl.TtlValue;
import org.apache.flink.util.Preconditions;

class HeapMapState<K, N, UK, UV>
extends AbstractHeapState<K, N, Map<UK, UV>>
implements InternalMapState<K, N, UK, UV> {
    private HeapMapState(StateTable<K, N, Map<UK, UV>> stateTable, TypeSerializer<K> keySerializer, TypeSerializer<Map<UK, UV>> valueSerializer, TypeSerializer<N> namespaceSerializer, Map<UK, UV> defaultValue) {
        super(stateTable, keySerializer, valueSerializer, namespaceSerializer, defaultValue);
        Preconditions.checkState((boolean)(valueSerializer instanceof MapSerializer), (Object)"Unexpected serializer type.");
    }

    @Override
    public TypeSerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public TypeSerializer<N> getNamespaceSerializer() {
        return this.namespaceSerializer;
    }

    @Override
    public TypeSerializer<Map<UK, UV>> getValueSerializer() {
        return this.valueSerializer;
    }

    public UV get(UK userKey) {
        Map userMap = (Map)this.stateTable.get(this.currentNamespace);
        if (userMap == null) {
            return null;
        }
        return (UV)userMap.get(userKey);
    }

    public void put(UK userKey, UV userValue) {
        HashMap<UK, UV> userMap = (HashMap<UK, UV>)this.stateTable.get(this.currentNamespace);
        if (userMap == null) {
            userMap = new HashMap<UK, UV>();
            this.stateTable.put(this.currentNamespace, userMap);
        }
        userMap.put(userKey, userValue);
    }

    public void putAll(Map<UK, UV> value) {
        HashMap<UK, UV> userMap = (HashMap<UK, UV>)this.stateTable.get(this.currentNamespace);
        if (userMap == null) {
            userMap = new HashMap<UK, UV>();
            this.stateTable.put(this.currentNamespace, userMap);
        }
        userMap.putAll(value);
    }

    public void remove(UK userKey) {
        Map userMap = (Map)this.stateTable.get(this.currentNamespace);
        if (userMap == null) {
            return;
        }
        userMap.remove(userKey);
        if (userMap.isEmpty()) {
            this.clear();
        }
    }

    public boolean contains(UK userKey) {
        Map userMap = (Map)this.stateTable.get(this.currentNamespace);
        return userMap != null && userMap.containsKey(userKey);
    }

    public Iterable<Map.Entry<UK, UV>> entries() {
        Map userMap = (Map)this.stateTable.get(this.currentNamespace);
        return userMap == null ? Collections.emptySet() : userMap.entrySet();
    }

    public Iterable<UK> keys() {
        Map userMap = (Map)this.stateTable.get(this.currentNamespace);
        return userMap == null ? Collections.emptySet() : userMap.keySet();
    }

    public Iterable<UV> values() {
        Map userMap = (Map)this.stateTable.get(this.currentNamespace);
        return userMap == null ? Collections.emptySet() : userMap.values();
    }

    public Iterator<Map.Entry<UK, UV>> iterator() {
        Map userMap = (Map)this.stateTable.get(this.currentNamespace);
        return userMap == null ? Collections.emptyIterator() : userMap.entrySet().iterator();
    }

    public boolean isEmpty() {
        Map userMap = (Map)this.stateTable.get(this.currentNamespace);
        return userMap == null || userMap.isEmpty();
    }

    @Override
    public byte[] getSerializedValue(byte[] serializedKeyAndNamespace, TypeSerializer<K> safeKeySerializer, TypeSerializer<N> safeNamespaceSerializer, TypeSerializer<Map<UK, UV>> safeValueSerializer) throws Exception {
        Preconditions.checkNotNull((Object)serializedKeyAndNamespace);
        Preconditions.checkNotNull(safeKeySerializer);
        Preconditions.checkNotNull(safeNamespaceSerializer);
        Preconditions.checkNotNull(safeValueSerializer);
        Tuple2 keyAndNamespace = KvStateSerializer.deserializeKeyAndNamespace((byte[])serializedKeyAndNamespace, safeKeySerializer, safeNamespaceSerializer);
        Map result = (Map)this.stateTable.get(keyAndNamespace.f0, keyAndNamespace.f1);
        if (result == null) {
            return null;
        }
        MapSerializer serializer = (MapSerializer)safeValueSerializer;
        TypeSerializer dupUserKeySerializer = serializer.getKeySerializer();
        TypeSerializer dupUserValueSerializer = serializer.getValueSerializer();
        return KvStateSerializer.serializeMap(result.entrySet(), (TypeSerializer)dupUserKeySerializer, (TypeSerializer)dupUserValueSerializer);
    }

    @Override
    public Map<UK, UV> migrateTtlValue(Map<UK, UV> stateValue, TtlAwareSerializer<Map<UK, UV>, ?> currentTtlAwareSerializer, TtlTimeProvider ttlTimeProvider) {
        if (currentTtlAwareSerializer.isTtlEnabled()) {
            for (Map.Entry<UK, UV> entry : stateValue.entrySet()) {
                TtlValue<UV> value = new TtlValue<UV>(entry.getValue(), ttlTimeProvider.currentTimestamp());
                stateValue.put(entry.getKey(), value);
            }
        } else {
            for (Map.Entry<UK, UV> entry : stateValue.entrySet()) {
                Object value = ((TtlValue)entry.getValue()).getUserValue();
                stateValue.put(entry.getKey(), value);
            }
        }
        return stateValue;
    }

    static <UK, UV, K, N, SV, S extends State, IS extends S> IS create(StateDescriptor<S, SV> stateDesc, StateTable<K, N, SV> stateTable, TypeSerializer<K> keySerializer) {
        return (IS)new HeapMapState<K, N, UK, UV>(stateTable, keySerializer, stateTable.getStateSerializer(), stateTable.getNamespaceSerializer(), (Map)stateDesc.getDefaultValue());
    }

    static <UK, UV, K, N, SV, S extends State, IS extends S> IS update(StateDescriptor<S, SV> stateDesc, StateTable<K, N, SV> stateTable, IS existingState) {
        return (IS)((HeapMapState)existingState).setNamespaceSerializer(stateTable.getNamespaceSerializer()).setValueSerializer(stateTable.getStateSerializer()).setDefaultValue((Map)stateDesc.getDefaultValue());
    }
}

