/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptive.allocator;

import java.util.Objects;
import org.apache.flink.util.Preconditions;

class SlotsUtilization {
    private final int total;
    private final int reserved;

    SlotsUtilization(int total, int reserved) {
        Preconditions.checkArgument((total >= reserved ? 1 : 0) != 0, (Object)"The total value must be >= reserved value.");
        Preconditions.checkArgument((reserved >= 0 ? 1 : 0) != 0, (Object)"The reserved number must not be negative.");
        this.total = total;
        this.reserved = reserved;
    }

    SlotsUtilization incReserved(int inc) {
        Preconditions.checkArgument((inc > 0 ? 1 : 0) != 0, (Object)"The increment number must be greater than zero.");
        Preconditions.checkArgument((this.reserved + inc <= this.total ? 1 : 0) != 0, (Object)"The increment result must be equal to or less than the total value.");
        return new SlotsUtilization(this.total, this.reserved + inc);
    }

    double getUtilization() {
        if (this.total == 0 && this.reserved == 0) {
            return 1.0;
        }
        return (double)this.reserved / (double)this.total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotsUtilization that = (SlotsUtilization)o;
        return this.total == that.total && this.reserved == that.reserved;
    }

    public int hashCode() {
        return Objects.hash(this.total, this.reserved);
    }
}

