/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import java.util.Map;
import java.util.Set;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationGroup;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.scheduler.AbstractSlotSharingStrategy;
import org.apache.flink.runtime.scheduler.ExecutionSlotSharingGroup;
import org.apache.flink.runtime.scheduler.SlotSharingStrategy;
import org.apache.flink.runtime.scheduler.TaskBalancedExecutionSlotSharingGroupBuilder;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingTopology;
import org.apache.flink.runtime.topology.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TaskBalancedPreferredSlotSharingStrategy
extends AbstractSlotSharingStrategy {
    public static final Logger LOG = LoggerFactory.getLogger(TaskBalancedPreferredSlotSharingStrategy.class);

    TaskBalancedPreferredSlotSharingStrategy(SchedulingTopology topology, Set<SlotSharingGroup> slotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
        super(topology, slotSharingGroups, coLocationGroups);
    }

    @Override
    protected Map<ExecutionVertexID, ExecutionSlotSharingGroup> computeExecutionSlotSharingGroups(SchedulingTopology schedulingTopology) {
        return new TaskBalancedExecutionSlotSharingGroupBuilder(TaskBalancedPreferredSlotSharingStrategy.getExecutionVertices(schedulingTopology, Vertex::getId), this.logicalSlotSharingGroups, this.coLocationGroups).build();
    }

    static class Factory
    implements SlotSharingStrategy.Factory {
        Factory() {
        }

        @Override
        public TaskBalancedPreferredSlotSharingStrategy create(SchedulingTopology topology, Set<SlotSharingGroup> slotSharingGroups, Set<CoLocationGroup> coLocationGroups) {
            return new TaskBalancedPreferredSlotSharingStrategy(topology, slotSharingGroups, coLocationGroups);
        }
    }
}

