/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph;

import java.util.UUID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.topology.ResultID;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.util.AbstractID;

public class IntermediateDataSetID
extends AbstractID
implements ResultID {
    private static final long serialVersionUID = 1L;

    public IntermediateDataSetID() {
    }

    public IntermediateDataSetID(JobVertexID sourceId, int edgeId) {
        super(sourceId.getUpperPart() + (long)edgeId, sourceId.getLowerPart() + (long)edgeId);
    }

    public IntermediateDataSetID(AbstractID from) {
        super(from);
    }

    public IntermediateDataSetID(UUID from) {
        super(from.getLeastSignificantBits(), from.getMostSignificantBits());
    }

    private IntermediateDataSetID(long lower, long upper) {
        super(lower, upper);
    }

    public void writeTo(ByteBuf buf) {
        buf.writeLong(this.lowerPart);
        buf.writeLong(this.upperPart);
    }

    public static IntermediateDataSetID fromByteBuf(ByteBuf buf) {
        long lower = buf.readLong();
        long upper = buf.readLong();
        return new IntermediateDataSetID(lower, upper);
    }
}

