/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.embedded;

import java.util.HashMap;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.highavailability.nonha.AbstractNonHaServices;
import org.apache.flink.runtime.highavailability.nonha.embedded.EmbeddedLeaderService;
import org.apache.flink.runtime.leaderelection.LeaderElection;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class EmbeddedHaServices
extends AbstractNonHaServices {
    private final Executor executor;
    private final EmbeddedLeaderService resourceManagerLeaderService;
    private final EmbeddedLeaderService dispatcherLeaderService;
    private final HashMap<JobID, EmbeddedLeaderService> jobManagerLeaderServices;
    private final EmbeddedLeaderService clusterRestEndpointLeaderService;

    public EmbeddedHaServices(Executor executor) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.resourceManagerLeaderService = this.createEmbeddedLeaderService(executor);
        this.dispatcherLeaderService = this.createEmbeddedLeaderService(executor);
        this.jobManagerLeaderServices = new HashMap();
        this.clusterRestEndpointLeaderService = this.createEmbeddedLeaderService(executor);
    }

    @Override
    public LeaderRetrievalService getResourceManagerLeaderRetriever() {
        return this.resourceManagerLeaderService.createLeaderRetrievalService();
    }

    @Override
    public LeaderRetrievalService getDispatcherLeaderRetriever() {
        return this.dispatcherLeaderService.createLeaderRetrievalService();
    }

    @Override
    public LeaderElection getResourceManagerLeaderElection() {
        return this.resourceManagerLeaderService.createLeaderElectionService("resource_manager");
    }

    @Override
    public LeaderElection getDispatcherLeaderElection() {
        return this.dispatcherLeaderService.createLeaderElectionService("dispatcher");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID) {
        Preconditions.checkNotNull((Object)jobID);
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            EmbeddedLeaderService service = this.getOrCreateJobManagerService(jobID);
            return service.createLeaderRetrievalService();
        }
    }

    @Override
    public LeaderRetrievalService getJobManagerLeaderRetriever(JobID jobID, String defaultJobManagerAddress) {
        return this.getJobManagerLeaderRetriever(jobID);
    }

    @Override
    public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        return this.clusterRestEndpointLeaderService.createLeaderRetrievalService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderElection getJobManagerLeaderElection(JobID jobID) {
        Preconditions.checkNotNull((Object)jobID);
        Object object = this.lock;
        synchronized (object) {
            this.checkNotShutdown();
            EmbeddedLeaderService service = this.getOrCreateJobManagerService(jobID);
            return service.createLeaderElectionService("job-" + String.valueOf(jobID));
        }
    }

    @Override
    public LeaderElection getClusterRestEndpointLeaderElection() {
        return this.clusterRestEndpointLeaderService.createLeaderElectionService("rest_server");
    }

    EmbeddedLeaderService getDispatcherLeaderService() {
        return this.dispatcherLeaderService;
    }

    EmbeddedLeaderService getJobManagerLeaderService(JobID jobId) {
        return this.jobManagerLeaderServices.get(jobId);
    }

    EmbeddedLeaderService getResourceManagerLeaderService() {
        return this.resourceManagerLeaderService;
    }

    @Nonnull
    private EmbeddedLeaderService createEmbeddedLeaderService(Executor executor) {
        return new EmbeddedLeaderService(executor);
    }

    @GuardedBy(value="lock")
    private EmbeddedLeaderService getOrCreateJobManagerService(JobID jobID) {
        EmbeddedLeaderService service = this.jobManagerLeaderServices.get(jobID);
        if (service == null) {
            service = this.createEmbeddedLeaderService(this.executor);
            this.jobManagerLeaderServices.put(jobID, service);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isShutDown()) {
                for (EmbeddedLeaderService service : this.jobManagerLeaderServices.values()) {
                    service.shutdown();
                }
                this.jobManagerLeaderServices.clear();
                this.resourceManagerLeaderService.shutdown();
                this.clusterRestEndpointLeaderService.shutdown();
            }
            super.close();
        }
    }
}

