/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Arrays;
import org.apache.flink.runtime.state.ChainedStateHandle;
import org.apache.flink.runtime.state.CompositeStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.runtime.state.StateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class SubtaskState
implements CompositeStateHandle {
    private static final Logger LOG = LoggerFactory.getLogger(SubtaskState.class);
    private static final long serialVersionUID = -2394696997971923995L;
    private final ChainedStateHandle<OperatorStateHandle> managedOperatorState;
    private final ChainedStateHandle<OperatorStateHandle> rawOperatorState;
    private final KeyedStateHandle managedKeyedState;
    private final KeyedStateHandle rawKeyedState;
    private final long stateSize;

    public SubtaskState(ChainedStateHandle<OperatorStateHandle> managedOperatorState, ChainedStateHandle<OperatorStateHandle> rawOperatorState, KeyedStateHandle managedKeyedState, KeyedStateHandle rawKeyedState) {
        this.managedOperatorState = managedOperatorState;
        this.rawOperatorState = rawOperatorState;
        this.managedKeyedState = managedKeyedState;
        this.rawKeyedState = rawKeyedState;
        try {
            long calculateStateSize = SubtaskState.getSizeNullSafe(managedOperatorState);
            calculateStateSize += SubtaskState.getSizeNullSafe(rawOperatorState);
            calculateStateSize += SubtaskState.getSizeNullSafe(managedKeyedState);
            this.stateSize = calculateStateSize += SubtaskState.getSizeNullSafe(rawKeyedState);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get state size.", e);
        }
    }

    private static long getSizeNullSafe(StateObject stateObject) throws Exception {
        return stateObject != null ? stateObject.getStateSize() : 0L;
    }

    public ChainedStateHandle<OperatorStateHandle> getManagedOperatorState() {
        return this.managedOperatorState;
    }

    public ChainedStateHandle<OperatorStateHandle> getRawOperatorState() {
        return this.rawOperatorState;
    }

    public KeyedStateHandle getManagedKeyedState() {
        return this.managedKeyedState;
    }

    public KeyedStateHandle getRawKeyedState() {
        return this.rawKeyedState;
    }

    @Override
    public void discardState() {
        try {
            StateUtil.bestEffortDiscardAllStateObjects(Arrays.asList(this.managedOperatorState, this.rawOperatorState, this.managedKeyedState, this.rawKeyedState));
        }
        catch (Exception e) {
            LOG.warn("Error while discarding operator states.", (Throwable)e);
        }
    }

    @Override
    public void registerSharedStates(SharedStateRegistry sharedStateRegistry, long checkpointID) {
        if (this.managedKeyedState != null) {
            this.managedKeyedState.registerSharedStates(sharedStateRegistry, checkpointID);
        }
        if (this.rawKeyedState != null) {
            this.rawKeyedState.registerSharedStates(sharedStateRegistry, checkpointID);
        }
    }

    @Override
    public long getStateSize() {
        return this.stateSize;
    }

    @Override
    public long getCheckpointedSize() {
        return this.stateSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubtaskState that = (SubtaskState)o;
        if (this.stateSize != that.stateSize) {
            return false;
        }
        if (this.managedOperatorState != null ? !this.managedOperatorState.equals(that.managedOperatorState) : that.managedOperatorState != null) {
            return false;
        }
        if (this.rawOperatorState != null ? !this.rawOperatorState.equals(that.rawOperatorState) : that.rawOperatorState != null) {
            return false;
        }
        if (this.managedKeyedState != null ? !this.managedKeyedState.equals(that.managedKeyedState) : that.managedKeyedState != null) {
            return false;
        }
        return this.rawKeyedState != null ? this.rawKeyedState.equals(that.rawKeyedState) : that.rawKeyedState == null;
    }

    public int hashCode() {
        int result = this.managedOperatorState != null ? this.managedOperatorState.hashCode() : 0;
        result = 31 * result + (this.rawOperatorState != null ? this.rawOperatorState.hashCode() : 0);
        result = 31 * result + (this.managedKeyedState != null ? this.managedKeyedState.hashCode() : 0);
        result = 31 * result + (this.rawKeyedState != null ? this.rawKeyedState.hashCode() : 0);
        result = 31 * result + (int)(this.stateSize ^ this.stateSize >>> 32);
        return result;
    }

    public String toString() {
        return "SubtaskState{operatorStateFromBackend=" + String.valueOf(this.managedOperatorState) + ", operatorStateFromStream=" + String.valueOf(this.rawOperatorState) + ", keyedStateFromBackend=" + String.valueOf(this.managedKeyedState) + ", keyedStateFromStream=" + String.valueOf(this.rawKeyedState) + ", stateSize=" + this.stateSize + "}";
    }
}

